@extends("main")
@setmenu("why")
@section('metaTags')
    @pageTitle(seoTitle($page->meta,$page->{'name_'._clang()}))
    @pageDescription(seoDescription($page->meta,$page->{'content_'._clang()}))
    @pageImage($page->getPhoto())
@endsection
@section("content")
    <div class="sub-page">
        <div class="sub-hero" style="background-image:url({{ $page->getPhoto() }});">
            <div class="wrap">
                <div class="page-title tac">{{ $page->name }}</div>
                <div class="breadcrumb">
                    <section>
                        <a href="{{ route("front.home") }}">{{ trans("breadcrumb.home") }}</a>
                        <i>/</i>
                        <a href="#">{{ trans("breadcrumb.corporate") }}</a>
                        <i>/</i>
                        <strong>{{ $page->name }}</strong>
                    </section>
                </div>
            </div>
        </div>
        <div class="mask"><img src="{{ asset("images/mask-hero.png") }}" alt=""/></div>
    </div>

    <div class="w100 porsion-about-wrap top-50">
        <div class="wrap-slim">
            <div class="page-title tac">
                {!! $page->spot !!}
            </div>
            <div class="w100 top-50 bottom-100">
                <div class="box">
                    <div class="box-content">
                        <div class="page-text"><strong>{!! $page->content !!}</strong></div>
                    </div>
                    <div class="box-cta">
                        <div class="link-all"><a
                                    href="{{ route("front.contact") }}">{{ trans("corporate.now_contact") }}</a></div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <div class="w100 top-100 bottom-100">

        <div class="wrap">

            <div class="block-flexed bottom-100 reveal">
                <div class="flex-left">
                    <div class="medium-title">{{ $page2->name }}</div>
                </div>
                <div class="flex-right">
                    <div class="page-text">{!! $page2->content !!}</div>
                </div>
            </div>

            <div class="block-flexed bottom-100 reveal">
                <div class="flex-left">
                    <div class="medium-title">{{ $page3->name }}</div>
                </div>
                <div class="flex-right">
                    <div class="page-text">{!! $page3->content !!}</div>
                </div>
            </div>

            <div class="block-flexed bottom-100 reveal">
                <div class="flex-left">
                    <div class="medium-title">{{ $page4->name }}</div>
                </div>
                <div class="flex-right">
                    <div class="page-text">{!! $page4->content !!}</div>
                </div>
            </div>

            <div class="block-flexed bottom-100 reveal">
                <div class="flex-left">
                    <div class="medium-title">{{ $page5->name }}</div>
                </div>
                <div class="flex-right">
                    <div class="page-text">{!! $page5->content !!}</div>
                </div>
            </div>

            <div class="block-flexed bottom-100 reveal">
                <div class="flex-left">
                    <div class="medium-title">{{ $page6->name }}</div>
                </div>
                <div class="flex-right">
                    <div class="page-text">{!! $page6->content !!}</div>
                </div>
            </div>

            <div class="block-two fl bottom-50 reveal">
                <div class="medium-title space-bottom">{{ $page7->name }}</div>
                <div class="page-text bottom-50">{!! $page7->content !!}</div>
                <div class="box">
                    <div class="box-content">
                        <div class="page-text"><strong>{!! $page7->spot !!}</strong></div>
                    </div>
                    <div class="box-cta">
                        <div class="link-all"><a
                                    href="{{ route("front.contact") }}">{{ trans("corporate.now_contact") }}</a></div>
                    </div>
                </div>
            </div>

            <div class="block-two fr bottom-50 reveal">
                <div class="medium-title space-bottom">{{ $page8->name }}</div>
                <div class="page-text bottom-50">{!! $page8->content !!}</div>
                <div class="box">
                    <div class="box-content">
                        <div class="page-text"><strong>{!! $page8->spot !!}</strong></div>
                    </div>
                    <div class="box-cta">
                        <div class="link-all"><a
                                    href="{{ route("front.contact") }}">{{ trans("corporate.now_contact") }}</a></div>
                    </div>
                </div>
            </div>

        </div>

    </div>
@endsection