@extends("main")
@setmenu("values")
@section('metaTags')
    @pageTitle(seoTitle($page->meta,$page->{'name_'._clang()}))
    @pageDescription(seoDescription($page->meta,$page->{'content_'._clang()}))
    @pageImage($page->getPhoto())
@endsection
@section("content")
    <div class="sub-page">
        <div class="sub-hero" style="background-image:url({{ $page->getPhoto() }});">
            <div class="wrap">
                <div class="page-title tac">{{ $page->name }}</div>
                <div class="breadcrumb">
                    <section>
                        <a href="{{ route("front.home") }}">{{ trans("breadcrumb.home") }}</a>
                        <i>/</i>
                        <a href="#">{{ trans("breadcrumb.corporate") }}</a>
                        <i>/</i>
                        <strong>{{ $page->name }}</strong>
                    </section>
                </div>
            </div>
        </div>
        <div class="mask"><img src="{{ asset("images/mask-hero.png") }}" alt=""/></div>
    </div>

    <div class="w100 top-100 bottom-100">

        <div class="wrap">

            <div class="block-flexed bottom-100">
                <div class="flex-left">
                    <div class="medium-title">{{ $page->spot }}</div>
                </div>
                <div class="flex-right">
                    <div class="page-summary">
                        {!! $page->content !!}
                    </div>
                </div>
            </div>

            <div class="promo-wrap">
                <div class="promo">
                    <ul>

                        <li class="reveal">
                            <div class="promo-content">
                                <div class="medium-title space-bottom">{{ $val1->name }}</div>
                                <div class="page-text">{!! $val1->content !!}</div>
                            </div>
                            <picture><img src="{{ $val1->getPhoto() }}" alt=""/></picture>
                        </li>

                        <li class="reveal">
                            <picture><img src="{{ $val2->getPhoto() }}" alt=""/></picture>
                            <div class="promo-content">
                                <div class="medium-title space-bottom">{{ $val2->name }}</div>
                                <div class="page-text">{!! $val2->content !!}</div>
                            </div>
                        </li>

                        <li class="reveal">
                            <div class="promo-content">
                                <div class="medium-title space-bottom">{{ $val3->name }}</div>
                                <div class="page-text">{!! $val3->content !!}</div>
                            </div>
                            <picture><img src="{{ $val3->getPhoto() }}" alt=""/></picture>
                        </li>

                        <li class="reveal">
                            <picture><img src="{{ $val4->getPhoto() }}" alt=""/></picture>
                            <div class="promo-content">
                                <div class="medium-title space-bottom">{{ $val4->name }}</div>
                                <div class="page-text">{!! $val4->content !!}</div>
                            </div>
                        </li>

                    </ul>
                </div>
            </div>

        </div>

    </div>
@endsection