@extends("main")
@setmenu("quality")
@section('metaTags')
    @pageTitle(seoTitle($page1->meta,$page1->{'name_'._clang()}))
    @pageDescription(seoDescription($page1->meta,$page1->{'content_'._clang()}))
    @pageImage($page1->getPhoto())
@endsection
@section("content")
    <div class="sub-page">
        <div class="sub-hero" style="background-image:url({{ $page1->getPhoto() }});">
            <div class="wrap">
                <div class="page-title tac">{{ $page1->name }}</div>
                <div class="breadcrumb">
                    <section>
                        <a href="{{ route("front.home") }}">{{ trans("breadcrumb.home") }}</a>
                        <i>/</i>
                        <a href="#">{{ trans("breadcrumb.corporate") }}</a>
                        <i>/</i>
                        <strong>{{ $page1->name }}</strong>
                    </section>
                </div>
            </div>
        </div>
        <div class="mask"><img src="{{ asset("images/mask-hero.png") }}" alt=""/></div>
    </div>

    <div class="w100 top-100 bottom-100">

        <div class="wrap">

            <div class="block-two fl bottom-50">
                <div class="medium-title space-bottom">{{ $page1->spot }}</div>
                <div class="page-text bottom-50">{!! $page1->content !!}</div>

                <div class="box">
                    <div class="box-content">
                        <div class="page-text">{!! $contactCard1->content !!}</div>
                    </div>
                    <div class="box-cta">
                        <div class="link-all"><a href="#">{{ $contactCard1->name }}</a></div>
                    </div>
                </div>
            </div>

            <div class="block-two fr bottom-50">
                <div class="medium-title space-bottom">{{ $page2->name }}</div>
                <div class="page-text bottom-50">{!! $page2->content !!}</div>
                <div class="box">
                    <div class="box-content">
                        <div class="page-text">{!! $contactCard2->content !!}</div>
                    </div>
                    <div class="box-cta">
                        <div class="link-all"><a href="#">{{ $contactCard2->name }}</a></div>
                    </div>
                </div>
            </div>

        </div>

    </div>
@endsection