@extends("main")
@setmenu("career")
@section('metaTags')
    @pageTitle(seoTitle($page->meta,$page->{'name_'._clang()}))
    @pageDescription(seoDescription($page->meta,$page->{'content_'._clang()}))
    @pageImage($page->getPhoto())
@endsection
@section("content")
    <div class="sub-page">
        <div class="sub-hero" style="background-image:url({{ $page->getPhoto() }});">
            <div class="wrap">
                <div class="page-title tac">{{ $page->name }}</div>
                <div class="breadcrumb">
                    <section>
                        <a href="{{ route("front.home") }}">{{ trans("breadcrumb.home") }}</a>
                        <i>/</i>
                        <strong>{{ $page->name }}</strong>
                    </section>
                </div>
            </div>
        </div>
        <div class="mask"><img src="{{ asset("images/mask-hero.png") }}" alt=""/></div>
    </div>

    {!! $page->content !!}

@endsection