@extends("main")
@setmenu("about")
@section('metaTags')
    @pageTitle(seoTitle($page->meta,$page->{'name_'._clang()}))
    @pageDescription(seoDescription($page->meta,$page->{'content_'._clang()}))
    @pageImage($page->getPhoto())
@endsection
@section("content")
    <div class="sub-page">
        <div class="sub-hero" style="background-image:url({{ $page->getPhoto() }});">
            <div class="wrap">
                <div class="page-title tac">{{ $page->name }}</div>
                <div class="breadcrumb">
                    <section>
                        <a href="{{ route("front.home") }}">{{ trans("breadcrumb.home") }}</a>
                        <i>/</i>
                        <a href="#">{{ trans("breadcrumb.corporate") }}</a>
                        <i>/</i>
                        <strong>{{ $page->name }}</strong>
                    </section>
                </div>
            </div>
        </div>
        <div class="mask"><img src="{{ asset("images/mask-hero.png") }}" alt=""/></div>
    </div>

    <div class="w100 top-100 bottom-100">

        <div class="wrap">

            <div class="block-flexed bottom-100">
                <div class="flex-left">
                    <div class="medium-title">{!! $page->spot !!}</div>
                </div>
                <div class="flex-right">
                    <div class="page-summary">{!! $page->content !!}</div>
                </div>
            </div>

            <div class="w100 bottom-100 reveal">
                <div class="porsion-advantages advantages-full">
                    <ul>
                        @foreach($widgets as $widget)
                            <li>
                                <div class="advantage-item">
                                    <section>
                                        <picture><img src="{{ $widget->getPhoto() }}" alt=""/></picture>
                                        <strong>{{ $widget->name }}</strong>
                                    </section>
                                    <small>{!! $widget->content !!}</small>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>

            <div class="promo-wrap">
                <div class="promo">
                    <ul>
                        <li class="reveal">
                            <div class="promo-content">
                                <div class="medium-title space-bottom">{{ $horeca->name }}</div>
                                <div class="page-text">{!! $horeca->content !!}</div>
                            </div>
                            <picture><img src="{{ $horeca->getPhoto() }}" alt=""/></picture>
                        </li>
                        <li class="reveal">
                            <picture><img src="{{ $retail->getPhoto() }}" alt=""/></picture>
                            <div class="promo-content">
                                <div class="medium-title space-bottom">{{ $retail->name }}</div>
                                <div class="page-text">{!! $retail->content !!}</div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="page-text top-100">

                {!! $endText->content !!}

            </div>

        </div>

    </div>
@endsection