@extends("main")
@setmenu("contact")
@section('metaTags')
    @pageTitle(seoTitle($page->meta,$page->{'name_'._clang()}))
    @pageDescription(seoDescription($page->meta,$page->{'content_'._clang()}))
    @pageImage($page->getPhoto())
@endsection
@section("content")
    <div class="sub-page">
        <div class="sub-hero" style="background-image:url({{ $page->getPhoto() }});">
            <div class="wrap">
                <div class="page-title tac">{{ $page->name }}</div>
                <div class="breadcrumb">
                    <section>
                        <a href="{{ route("front.home") }}">{{ trans("breadcrumb.home") }}</a>
                        <i>/</i>
                        <strong>{{ $page->name }}</strong>
                    </section>
                </div>
            </div>
        </div>
        <div class="mask"><img src="{{ asset("images/mask-hero.png") }}" alt=""/></div>
    </div>

    <div class="w100 top-100 bottom-100">

        <div class="wrap">

            <div class="block-flexed bottom-100">
                <div class="flex-left">
                    <div class="medium-title space-bottom">{{ $page->spot }}</div>
                    <div class="page-text">{!! $page->content !!}</div>
                </div>
                <div class="flex-right">
                    <div class="contact-info">
                        <section>
                            <img src="{{ asset("images/icon-phone.png") }}" alt="">
                            <small>{{ trans("contact.phone") }}</small>
                            <article><strong>{{ $configs["ph1"] }}</strong></article>
                        </section>
                        @if($configs["ph2"])
                            <section>
                                <img src="{{ asset("images/icon-phone.png") }}" alt="">
                                <small>{{ trans("contact.phone") }}</small>
                                <article><strong>{{ $configs["ph2"] }}</strong></article>
                            </section>
                        @endif
                        <section>
                            <img src="{{ asset("images/icon-mail.png") }}" alt="">
                            <small>{{ trans("contact.email") }}</small>
                            <article>{{ $configs["mail"] }}</article>
                        </section>
                        <section>
                            <img src="{{ asset("images/icon-pin.png") }}" alt="">
                            <small>{{ trans("contact.address") }}</small>
                            <article>{{ $configs["adr"] }}/ BURSA</article>
                        </section>
                    </div>
                </div>
            </div>

            <div class="block-flexed bottom-100">
                <div class="flex-left">
                    <div class="medium-title space-bottom">{{ trans("contact.ctitle") }}</div>
                    <div class="page-text">{!! trans("contact.ccontent") !!}
                    </div>
                    <div class="contact-form">
                        <div class="inner-15">
                            {!! html()->form('POST',route('front.contact_submit'))->open() !!}

                            <div class="form-item">
                                {!! html()->text('name')->placeholder(trans('contact.name'))->required(true)->addClass('input') !!}
                            </div>

                            <div class="form-item">
                                {!! html()->email('email')->placeholder(trans('contact.mail'))->required(true)->addClass('input') !!}
                            </div>

                            <div class="form-item">
                                {!! html()->text('phone')->placeholder(trans('contact.phone_number'))->required(true)->addClass('input') !!}
                            </div>

                            <div class="form-item">
                                {!! html()->text('subject')->placeholder(trans('contact.subject'))->required(true)->addClass('input') !!}
                            </div>

                            <div class="form-item w100">
                                {!! html()->textarea('body')->placeholder(trans('contact.messages'))->required(true)->addClass('input')->attributes(['rows' => 5])->style('height:100px;') !!}
                            </div>

                            {{--<div class="form-item w100">
                                <label><input name="ad_soyad" type="checkbox"/> <a href="#">KVKK Aydınlatma Metni</a>'ni okudum, onaylıyorum</label>
                            </div>--}}
                            <div class="form-item w100">
                                <button id="send" class="button">{{ trans("contact.send") }}</button>
                            </div>
                            {!! html()->form()->close() !!}
                        </div>
                    </div>
                </div>
                <div class="flex-right">
                    <div class="contact-map">
                        <iframe src="{!! $configs["mk"] !!}"
                                width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"
                                referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>

        </div>

    </div>
@endsection