@extends("main")
@setmenu($type)
@section('metaTags')
    @pageTitle(seoTitle($page->meta,$page->{'name_'._clang()}))
    @pageDescription(seoDescription($page->meta,$page->{'content_'._clang()}))
    @pageImage($page->getPhoto())
@endsection
@section("content")
    @include("front.blog._.breadcrumb")
    <div class="w100 top-50 bottom-100">
        <div class="wrap">
            <div class="news-list">
                <ul>
                    @foreach($data->articles as $article)
                        <li>
                            <a href="{{ route("front.new", ["slug" => $article->slug]) }}" class="news-item">
                                <time>{{ $article->created_at->format("d.m.Y") }}</time>
                                <picture><i><img src="{{ $article->getPhoto() }}" alt=""/></i></picture>
                                <strong>{{ $article->name }}</strong>
                                <span>{{ trans("blog.readmore") }}</span>
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </div>
@endsection