@extends("main")
@setmenu($type)
@section('metaTags')
    @pageTitle(seoTitle($page->meta,$page->{'name_'._clang()}))
    @pageDescription(seoDescription($page->meta,$page->{'content_'._clang()}))
    @pageImage($page->getPhoto())
@endsection
@section("content")
    @include("front.blog._.breadcrumb")


    <div class="w100 top-50 bottom-100">

        <div class="wrap">

            <div class="tags">
                <label for="option-1">

                    <input
                            type="radio"
                            name="type"
                            value="all"
                            id="option-1"
                            checked=""/>
                    <small>{{ trans("blog.all") }}</small>
                </label>
                @foreach($data->childArticleCats()->get() as $articleCat)
                    <label for="option-{{ $articleCat->id }}">
                        <input
                                type="radio"
                                name="type"
                                value="{{ $articleCat->id }}"
                                id="option-{{ $articleCat->id }}"/>
                        <small>{{ $articleCat->name }}</small>
                    </label>
                @endforeach
            </div>

            <div class="news-list">
                <ul>
                    @foreach($data->childArticleCats()->get() as $articleCat)
                        @foreach($articleCat->articles as $article)
                            <li data-catid="{{ $articleCat->id }}">
                                <a href="{{ route("front.blog", ["slug" => $article->slug]) }}" class="news-item">
                                    <time>{{ $article->created_at->format("d.m.Y") }}</time>
                                    <picture><i><img src="{{ $article->getPhoto() }}" alt=""/></i></picture>
                                    <small><i>{{ $articleCat->name }}</i></small>
                                    <strong>{{ $article->name }}</strong>
                                    <span>{{ trans("blog.readmore") }}</span>
                                </a>
                            </li>
                        @endforeach
                    @endforeach
                </ul>
            </div>

            {{--<div class="pages">
                <ul>
                    <li><a href="#">1</a></li>
                    <li><a href="#" class="current">2</a></li>
                    <li><a href="#">3</a></li>
                    <li><a href="#">4</a></li>
                </ul>
            </div>--}}

        </div>

    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Tüm radio inputlarını ve haber listesini seç
            const radios = document.querySelectorAll('input[type="radio"][name="type"]');
            const newsItems = document.querySelectorAll('.news-list li');

            // Her bir radio input için bir event listener ekle
            radios.forEach(radio => {
                radio.addEventListener('change', function() {
                    const catId = this.value; // Seçilen kategorinin ID değeri

                    newsItems.forEach(item => {
                        if (catId === "all") {
                            // "Tümü" seçeneği seçildiğinde tüm haberleri göster
                            item.style.display = "";
                        } else {
                            // Seçilen kategorinin ID'si ile data-catid değeri eşleşiyorsa göster, değilse gizle
                            if (item.getAttribute('data-catid') === catId) {
                                item.style.display = "";
                            } else {
                                item.style.display = "none";
                            }
                        }
                    });
                });
            });
        });
    </script>

@endsection