@extends("main")
@setmenu($type)
@section('metaTags')
    @pageTitle(seoTitle($datum->meta,$datum->{'name_'._clang()}))
    @pageDescription(seoDescription($datum->meta,$datum->{'content_'._clang()}))
    @pageImage($datum->getPhoto())
@endsection
@section("content")
    @include("front.blog._.breadcrumb_detail")

    <div class="w100 top-50">
        <div class="wrap-slim">

            <div class="news-wrap" data-sticky-container>

                <div class="page-title news-title space-bottom">{{ $datum->name }}</div>
                <div class="news-photo"><img src="{{ $datum->getPhoto() }}" alt=""/></div>

                <div class="news-sidebar sticky" data-margin-top="100" data-sticky-for="1280"
                     data-sticky-class="is-sticky">
                    <time class="news-info">
                        <section>
                            <i>{{ trans("blog.added_date") }}</i>
                            <strong>{{ strtoupper($datum->created_at->locale('tr')->isoFormat('D MMMM YYYY')) }}</strong>
                        </section>
                    </time>
                    <div class="page-share">
                        <ul>
                            <li><a href="javascript:void(0);" class="ssk ssk-facebook"><img
                                            src="{{ asset('images/icon-facebook.png') }}" alt=""/></a></li>
                            <li><a href="javascript:void(0);" class="ssk ssk-twitter"><img
                                            src="{{ asset('images/icon-twitter.png') }}" alt=""/></a></li>
                            <li><a href="javascript:void(0);" class="ssk ssk-linkedin"><img
                                            src="{{ asset('images/icon-linkedin.png') }}" alt=""/></a></li>
                            <li><a href="whatsapp://send?text={{ url()->current() }}" class="share-whatsapp"><img
                                            src="{{ asset('images/icon-whatsapp.png') }}" alt=""/></a></li>
                        </ul>
                    </div>
                </div>

                <div class="news-content">

                    <div class="page-text">

                        {!! $datum->content !!}

                    </div>

                    <div class="gallery">
                        <div class="inner-5">
                            <ul>
                                @foreach($datum->images as $image)
                                    <li>
                                        <a class="fancybox" data-fancybox="selimoglu-gallery"
                                           href="{{ str_replace("\\", "/", $image->url()) }}">
                                            <section>
                                                <picture
                                                        style="background-image:url({{ str_replace("\\", "/", $image->url()) }});">
                                                    <img
                                                            src="{{ asset("images/for-gallery.png") }}" alt=""/>
                                                </picture>
                                            </section>
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>

                </div>

            </div>

        </div>
    </div>

    @include("front.blog._.other")
@endsection