@if($current_menu == "blog")
    <div class="w100 top-50 bottom-100">

        <div class="wrap">

            <div class="medium-title space-bottom">{{ trans("blog.barchive") }}</div>
            <div class="news-list mt10">
                <ul>
                    @foreach($others as $other)
                        <li>
                            <a href="{{ route("front.blog", ["slug" => $other->slug]) }}" class="news-item">
                                <time>{{ $other->created_at->format("d.m.Y") }}</time>
                                <picture><i><img src="{{ $other->getPhoto() }}" alt=""/></i></picture>
                                <strong>{{ $other->name }}</strong>
                                <span>{{ trans("blog.readmore") }}</span>
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>

            <div class="link-all"><a href="{{ route("front.blogs") }}">{{ trans("blog.all_blogs") }}</a></div>

        </div>

    </div>
@elseif($current_menu == "new")
    <div class="w100 top-50 bottom-100">

        <div class="wrap">

            <div class="medium-title space-bottom">{{ trans("blog.narchive") }}</div>
            <div class="news-list mt10">
                <ul>
                    @foreach($others as $other)
                        <li>
                            <a href="{{ route("front.new", ["slug" => $other->slug]) }}" class="news-item">
                                <time>{{ $other->created_at->format("d.m.Y") }}</time>
                                <picture><i><img src="{{ $other->getPhoto() }}" alt=""/></i></picture>
                                <strong>{{ $other->name }}</strong>
                                <span>{{ trans("blog.readmore") }}</span>
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>

            <div class="link-all"><a href="{{ route("front.news") }}">{{ trans("blog.all_news") }}</a></div>

        </div>

    </div>
@else
    <div class="w100 top-50 bottom-100">

        <div class="wrap">

            <div class="medium-title space-bottom">{{ trans("archive") }}</div>
            <div class="news-list mt10">
                <ul>
                    @foreach($others as $other)
                        <li>
                            <a href="{{ route("front.activity", ["slug" => $other->slug]) }}" class="news-item">
                                <time>{{ $other->created_at->format("d.m.Y") }}</time>
                                <picture><i><img src="{{ $other->getPhoto() }}" alt=""/></i></picture>
                                <strong>{{ $other->name }}</strong>
                                <span>{{ trans("blog.readmore") }}</span>
                            </a>
                        </li>
                    @endforeach
                </ul>
            </div>

            <div class="link-all"><a href="{{ route("front.activities") }}">{{ trans("blog.all_activities") }}</a></div>

        </div>

    </div>
@endif