<header class="header">
    <div id="logo"><a href="{{ route("front.home") }}" alt="PorsiOn Food"><img src="{{ asset("images/logo.png") }}"
                                                                               alt=""/></a></div>
    <div id="nav">
        <ul>
            <li><a href="{{ route("front.home") }}" class="active"><img src="{{ asset("images/icon-logo.png") }}"
                                                                        alt=""/><small>{{ trans("partials.home") }}</small></a>
            </li>
            <li class="nav-multi nav-pro">
                <a href="#" data-href="{{ route("front.products") }}">{{ trans("partials.products") }}</a>
                <div class="nav-menu">
                    <div class="nav-menu-pro">
                        <div class="nav-menu-pro-cats">
                            <ul>
                                @foreach($menuCategories as $key => $category)
                                    <li class="mobile-redirect"
                                        data-href="{{ route("front.category", ["slug" => $category->slug]) }}"
                                        data-hover="{{ $key+1 }}"><a
                                                href="#">
                                            <picture><img src="{{ $category->getCover() }}" alt=""/>
                                            </picture>
                                            <strong>{{ $category->name }}</strong></a></li>
                                @endforeach
                            </ul>
                        </div>
                        <div class="nav-menu-pro-right selectright" data-id="*" style="display:block;">
                            <div class="nav-menu-pro-in">
                                <div class="nav-menu-pro-title">{{ trans("partials.showroom_products") }}</div>
                                <div class="nav-menu-pro-list">
                                    <ul>
                                        @foreach($menuShowroomProducts as $showroomProd)
                                            <li>
                                                <a href="{{ route("front.product", ["category_slug" => $showroomProd->category->slug, "slug" => $showroomProd->slug]) }}">
                                                    <picture><img src="{{ $showroomProd->getCover() }}" alt=""/>
                                                    </picture>
                                                    <strong>{{ $showroomProd->name }}</strong>
                                                </a>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                                <div class="link-all"><a
                                            href="{{ route("front.products") }}">{{ trans("partials.all_products") }}</a>
                                </div>
                            </div>
                        </div>
                        @foreach($menuCategories as $key => $menuProds)
                            <div class="nav-menu-pro-right selectright" data-id="{{ $key+1 }}" style="display:none;">
                                <div class="nav-menu-pro-in">
                                    <div class="nav-menu-pro-title">{{ $menuProds->name }}</div>
                                    <div class="nav-menu-pro-list">
                                        <ul>
                                            @foreach($menuProds->menuProducts() as $mp)
                                                <li>
                                                    <a href="{{ route("front.product", ["category_slug" => $menuProds->slug, "slug" => $mp->slug]) }}">
                                                        <picture><img src="{{ $mp->getCover() }}" alt=""/>
                                                        </picture>
                                                        <strong>{{ $mp->name }}</strong>
                                                    </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                    <div class="link-all"><a
                                                href="{{ route("front.category", ["slug" => $menuProds->slug]) }}">{{ trans("partials.all_products") }}</a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </li>
            <li><a href="{{ route("front.location") }}">{{ trans("partials.where_are_we") }}</a></li>
            <li><a href="{{ route("front.guide") }}">{{ trans("partials.guide") }}</a></li>
            <li><a href="{{ route("front.faq") }}">{{ trans("partials.faq") }}</a></li>
        </ul>
        <ul class="fr">
            <li class="nav-multi">
                <a href="#">{{ trans("partials.corporate") }}</a>
                <div class="nav-menu">
                    <a href="{{ route("front.about") }}">{{ trans("partials.who_we") }}</a>
                    <a href="{{ route("front.values") }}">{{ trans("partials.values") }}</a>
                    <a href="{{ route("front.quality") }}">{{ trans("partials.quality") }}</a>
                    <a href="{{ route("front.why") }}">{{ trans("partials.why_porsion") }}</a>
                </div>
            </li>
            <li class="nav-multi">
                <a href="#">{{ trans("partials.blog") }}</a>
                <div class="nav-menu">
                    @foreach($basePress as $press)
                        <a href="{{ route("front.".$press->key) }}">{{ $press->name }}</a>
                    @endforeach
                </div>
            </li>
            <li><a href="{{ route("front.career") }}">{{ trans("partials.career") }}</a></li>
            <li><a href="{{ route("front.contact") }}">{{ trans("partials.contact") }}</a></li>
        </ul>
    </div>
    <div class="header-lang-wrap">
        <div class="header-lang-icon">{{ strtoupper(_clang())  }}</div>
        <div class="header-lang">
            <ul>
                @foreach(_otherLangs() as $key=>$val)
                    <li><a href="{{  _localizedCurrentUrl($key) }}">{{ strtoupper($key) }}</a></li>
                @endforeach
            </ul>
        </div>
    </div>
    <div class="search-icon">Search</div>
    {!! html()->form('GET', route('front.search'))->class("header-search")->open() !!}
        <input required="required" type="text" name="key" id="key"
               placeholder="{{ trans("partials.search_text") }}"/>
        <button id="send">Search</button>
    {!! html()->form()->close() !!}
    <div class="nav-icon"><span></span></div>
</header>

<div class="progress-page">
    <div class="progress-container">
        <div class="progress-bar" id="myBar"></div>
    </div>
</div>