$(function(){
	
	var $window = $(window);

	if ($window.width() > 1023) {
		$window.scroll(function() {
			if ($(document).scrollTop() >= 120) { 
				$('html').addClass('scroll');
			} else {
				$('html').removeClass('scroll');
			}	
		});
	}
	
	$(".header-lang-icon").click(function () {
		$(".header-lang").stop(true , true).slideToggle();
		return false;
	});
	
	$(".search-icon").click(function () {
		
		if ($(this).hasClass("search-icon-close")) {
		$(this).removeClass('search-icon-close');
		} else { 
		$(this).addClass('search-icon-close');
		}
		$(".header-search").stop(true , true).slideToggle();
		return false;
	});
	
	$(".nav-icon").click(function () {
		
		if ($('body').hasClass("nav-opened")) {
			$('body').removeClass('nav-opened');
		} else { 
			$('body').addClass('nav-opened');
		}
		
		$(this).toggleClass('nav-icon-close');
		$("#nav").stop(true , true).slideToggle();
		
		return false;
	});
	
	var $window = $(window);
	
	if ($window.width() > 1023) {
		
		function reveal() {
		  var reveals = document.querySelectorAll(".reveal");

		  for (var i = 0; i < reveals.length; i++) {
			var windowHeight = window.innerHeight;
			var elementTop = reveals[i].getBoundingClientRect().top;
			var elementVisible = 30;

			if (elementTop < windowHeight - elementVisible) {
			  reveals[i].classList.add("active");
			} else {
			  reveals[i].classList.remove("active");
			}
		  }
		}

		window.addEventListener("scroll", reveal);
		
	}
	
	let $counters = $('.count');

    // listen the window for scroll events
    $(document).scroll(checkCounters)
	
	function checkCounters(){
		// loop through the items
        $counters.each(function () {
            $counter = $(this)

            // skip if counter already animated
            if ($counter.hasClass('counter-ran')) return

            if (checkVisible(this)) {
                // add class to specify that this element has animated
                $counter.addClass('counter-ran')
                    // start the counter animation
                    .prop('Counter', 0).animate({
                    Counter: $(this).text()
                }, {
                    duration: 3000,
                    easing: 'swing',
                    step: function (now) {
                        $(this).text(Math.ceil(now));
                    }
                });
            }
        })
	}
	
	checkCounters();
	
	function checkVisible(elm, evalType) {
        evalType = evalType || "visible";

        var vpH = $(window).height(), // Viewport Height
            st = $(window).scrollTop(), // Scroll Top
            y = $(elm).offset().top,
            elementHeight = $(elm).height();

        if (evalType === "visible") return ((y < (vpH + st)) && (y > (st - elementHeight)));
        if (evalType === "above") return ((y < (vpH + st)));
    }
	
	window.onscroll = function() {myFunction()};

	function myFunction() {
	  var winScroll = document.body.scrollTop || document.documentElement.scrollTop;
	  var height = document.documentElement.scrollHeight - document.documentElement.clientHeight;
	  var scrolled = (winScroll / height) * 100;
	  document.getElementById("myBar").style.width = scrolled + "%";
	}
	
});

$(document).ready(function() {
	$(".sidebar-toggle").click(function(){
		
		$(this).parent().children('.sidebar-content').slideToggle();
		$(this).toggleClass('sidebar-closed')
	});
});

$(document).ready(function() {
	$('#fullpage').fullpage({
		verticalCentered: false,
		css3: true,
		navigation: false,
		scrollBar: true,
		navigationPosition: 'right',
		responsiveWidth: '1281',
		scrollingSpeed: 1000,
		navigationTooltips: ['Nabat', 'Kurumsal', 'EPDM Conta', 'Isı Bariyeri', 'Dorma Kaba', 'Sayfa sonu'],
		/* anchors: ['nabat', 'kurumsal', 'epdm-conta', 'isi-bariyeri', 'dorma-kaba', 'sayfa-sonu'], */

		onLeave: function(index, nextIndex, direction){
			if (index == 3 && direction == 'down'){
				$('.section').eq(index -1).removeClass('moveDown').addClass('moveUp');
			}
			else if(index == 3 && direction == 'up'){
				$('.section').eq(index -1).removeClass('moveUp').addClass('moveDown');
			}

			$('#staticImg').toggleClass('active', (index == 2 && direction == 'down' ) || (index == 4 && direction == 'up'));
			$('#staticImg').toggleClass('moveDown', nextIndex == 4);
			$('#staticImg').toggleClass('moveUp', index == 4 && direction == 'up');
		}
	});
});

$(document).ready(function() {
	
	$('.fancybox').fancybox();
	
	$('.cookies-close').click(function(e){
		$('body').find('.cookies').remove();	
	});
	
	$('.milestone-nav ul li a').click(function (e) {
    	e.preventDefault();
    	$('.milestone-nav ul li a').removeClass('active');
    	$(this).addClass('active')
		let index = $(this).attr('data-index');

    	$('.milestone-content').slick('slickGoTo',index);
	});

	$('.milestone-content').slick({
		arrows: false,
		touchMove: false,
		swipe: false,
		speed:750
	});
	
});

$(document).ready(function() {
	var sticky = new Sticky('.sticky');
});

$(document).ready(function(){
	
	jQuery('.slider-hero').bind('touchstart', function(){ console.log('touchstart') });
	$('.slider-hero').slick({
		arrows:false,
		dots:true,
		pauseOnHover:true,
		speed:750,
		responsive: [
		{
			breakpoint:1200,
			settings: {
				arrows:false,
				slidesToShow:1
			}
		}
		]
	});
	
	$('.slider-gallery').slick({
		dots:false,
		speed:750,
		slidesToShow:3,
		autoplay:false,
		responsive: [
		{
			breakpoint:768,
			settings: {
				slidesToShow:2
			}
		}
		,
		{
			breakpoint:550,
			settings: {
				slidesToShow:1
			}
		}
		]
	});
	
	jQuery('.slider-cat').bind('touchstart', function(){ console.log('touchstart') });
	$('.slider-cat').slick({
		dots:false,
		speed:750,
		centerMode:true,
		centerPadding:'0',
		slidesToShow: 3,
		autoplay:false,
		responsive: [
		{
			breakpoint:1200,
			settings: {
				centerPadding:'0'
			}
		}
		,
		{
			breakpoint:767,
			settings: {
				centerPadding:'0',
				slidesToShow:1,
			}
		}
		]
	});
	
	jQuery('.slider-markets').bind('touchstart', function(){ console.log('touchstart') });
	$('.slider-markets').slick({
		dots:false,
		pauseOnHover:true,
		speed:750,
		autoplay:false,
		slidesToShow:7,
		swipeToSlide:true,
		responsive: [
		{
			breakpoint:1441,
			settings: {
				slidesToShow:6
			}
		}
		,
		{
			breakpoint:1281,
			settings: {
				slidesToShow:5
			}
		}
		,
		{
			breakpoint:1081,
			settings: {
				slidesToShow:4
			}
		}
		,
		{
			breakpoint:1023,
			settings: "unslick"
		}
		]
	});
	
	$('.slider-wide').slick({
		dots:true,
		pauseOnHover:true,
		speed:750,
		autoplay:true,
		responsive: [
		{
			breakpoint:768,
			settings: {
				arrows:false
			}
		}
		]
	});
	
});

$(document).ready(function(){
	$('div#nav ul li.nav-multi > a').click(function(event){
		if ($(window).width() < 9999) {
			event.preventDefault();
			
			$(this).parent().parent().children('li').children('.nav-menu').not($(this).parent().children(".nav-menu")).slideUp();
			$(this).parent().children('.nav-menu').stop(true , true).slideToggle();
			return false;
		}	
	});
});

$(document).ready(function() {
    function close_accordion_section() {
        $('.accordion .accordion-section-title').removeClass('active');
        $('.accordion .accordion-section-content').slideUp(300).removeClass('open');
    }
 
    $('.accordion-section-title').click(function(e) {
        // Grab current anchor value
        var currentAttrValue = $(this).attr('href');
 
        if($(e.target).is('.active')) {
            close_accordion_section();
        }else {
            close_accordion_section();
 
            // Add active class to section title
            $(this).addClass('active');
            // Open up the hidden content panel
            $('.accordion ' + currentAttrValue).slideDown(300).addClass('open'); 
        }
 
        e.preventDefault();
    });
});

// Hide Header on scroll down
var didScroll;
var lastScrollTop = 0;
var delta = 5;
var navbarHeight = $('header').outerHeight();

$(document).ready(function(){
    window.didScroll;
    window.lastScrollTop = 0;
    window.delta = 5;
    window.navbarHeight = $('header').outerHeight();
});

$(window).scroll(function(event){
    didScroll = true;
});

setInterval(function() {
    if (didScroll) {
        hasScrolled();
        didScroll = false;
    }
}, 250);

function hasScrolled() {
	var hasReachedTop = $(this).scrollTop() < 80;
    var st = $(this).scrollTop()+80;
    console.log(hasReachedTop);
    // Make sure they scroll more than delta
    if(Math.abs(lastScrollTop - st) <= delta)
        return;
    
    // If they scrolled down and are past the navbar, add class .nav-up.
    // This is necessary so you never see what is "behind" the navbar.
	
	

    if (st > lastScrollTop && st > navbarHeight && !hasReachedTop){
        // Scroll Down
        $('header').removeClass('nav-down').addClass('nav-up');
    } else {
        // Scroll Up
        if(st + $(window).height() < $(document).height()) {
            $('header').removeClass('nav-up').addClass('nav-down');
        }
    }
	if(hasReachedTop){
		$('header').removeClass('nav-down').removeClass('nav-up');
	}
	
    lastScrollTop = st;
}

let parent = document.querySelectorAll('.animate-text');
for(let i = 0; i < parent.length; i++) {
  parent[i].style.width = parent[i].children[0].clientWidth + "px"; 
};


// menu operations

// .nav-menu-pro-cats li ana başlıkları verir
// .selectright yan ekranları verir

document.addEventListener('DOMContentLoaded', function (event) {


	// değişkenler alanı
	let titles = document.querySelectorAll('.nav-menu-pro-cats li');
	let rightAreas = document.querySelectorAll('.selectright');
	let mobileRedirect = document.querySelector('.mobile-redirect');

	if (window.innerWidth < 1023)
	{
		let mobileRedirectLink = mobileRedirect.dataset.href;
		let mobileA = mobileRedirect.querySelector('a');
		mobileA.href = mobileRedirectLink

		mobileA.addEventListener('click', () => {
			window.location = mobileRedirectLink
		})


	}

	// operasyonları tetikleme alanı
	titles.forEach((title) => {
		title.addEventListener('click', () => {
			if (window.innerWidth > 1023) {
				allRightAreasHide();
				showTheRightArea(title.dataset.hover);
				addActiveClassForTitles(title.dataset.hover);
			} else {
				window.location = title.dataset.href

			}
		});
	});


	// başlıklardan hangisine tıklanırsa ona active classı ver
	function addActiveClassForTitles(elementId) {
		// tabi önce hepsinden kaldır
		titles.forEach((title) => {
			title.classList.remove('active-pro');
			if (title.dataset.hover === elementId) {
				title.classList.add('active-pro');
			}
		});
	}

	// başlıklardan hangisine tıklanırsa ona ait olan id'li sağ elementi aktif et
	function showTheRightArea(elementId) {
		rightAreas.forEach((ria) => {
			if (ria.dataset.id === elementId) {
				ria.style.display = 'block';
			}
		});
	}

	// bütün sağ alanları disable eden fonksiyon
	function allRightAreasHide() {
		rightAreas.forEach((ra) => {
			ra.style.display = 'none';
		});
	}
});