$.views.settings.delimiters("<%", "%>");
var $uploader = [];

//region Templates
//region Single Image Template
var $uploader_singleImageUploadTemplate = '\n' +
    '<div class="card n-upload <%:key%>-uploader">\n' +
    '    <input type="file" class="fileuploader" name="<%:key%>-uploader-input"/>\n' +
    '    <div class="card-header header-elements-inline">\n' +
    '        <h5 class="card-title">\n' +
    '            <%:title%>\n' +
    '        </h5>\n' +
    '        <small><%:titleinfo%></small>\n' +
    '    </div>\n' +
    '    <div class="card-body">\n' +
    '        <div class="previewarea">\n' +
    '            <img src="<%:previewurl%>" alt="" class="preview" width="<%:previewwidth%>" height="<%:previewheight%>">\n' +
    '        </div>\n' +
    '        <div class="indicatorarea" style="display: none;">\n' +
    '            <div class="progress">\n' +
    '                <div class="progress-bar bg-teal" style="width: 0;">\n' +
    '                    <span>0%</span>\n' +
    '                </div>\n' +
    '            </div>\n' +
    '        </div>\n' +
    '        <div class="actionarea">\n' +
    '            <button class="upload"><i class="icon-file-upload"></i>Yükle</button>\n' +
    '            <button class="clear"><i class="icon-cross3"></i> Temizle</button>\n' +
    // '            <button class="crop"><i class="icon-crop"></i> Kes </button>\n' +
    '        </div>\n' +
    '    </div>\n' +
    '</div>';
//endregion

//region Single File Template
var $uploader_singleFileUploadTemplate = '\n' +
    '<div class="card n-upload <%:key%>-uploader">\n' +
    '    <input type="file" class="fileuploader" name="<%:key%>-uploader-input" />\n' +
    '    <div class="card-header header-elements-inline">\n' +
    '        <h5 class="card-title">\n' +
    '            <%:title%>\n' +
    '        </h5>\n' +
    '        <small><%:titleinfo%></small>\n' +
    '    </div>\n' +
    '    <div class="card-body">\n' +
    '        <div class="filearea">\n' +
    '            <span><%:filename%></span>\n' +
    '        </div>\n' +
    '        <div class="indicatorarea" style="display: none;">\n' +
    '            <div class="progress">\n' +
    '                <div class="progress-bar bg-teal" style="width: 0;">\n' +
    '                    <span>0%</span>\n' +
    '                </div>\n' +
    '            </div>\n' +
    '        </div>\n' +
    '        <div class="actionarea">\n' +
    '            <button class="upload"><i class="icon-file-upload"></i>Yükle</button>\n' +
    '            <button class="clear"><i class="icon-cross3"></i> Temizle</button>\n' +
    // '            <button class="crop"><i class="icon-crop"></i> Kes </button>\n' +
    '        </div>\n' +
    '    </div>\n' +
    '</div>';
//endregion

//region MultiImageUploader
var $uploader_multiImageUploadTemplate = '' +
    ' <div class="card n-upload <%:key%>-uploader">\n' +
    '    <input type="file" class="fileuploader" name="<%:key%>-uploader-input" multiple>\n' +
    '    <div class="card-header header-elements-inline">\n' +
    '        <h5 class="card-title">\n' +
    '              <%:title%>\n' +
    '        </h5>\n' +
    '        <div class="header-elements">\n' +
    '            <div class="actionarea">\n' +
    '                <button class="upload"><i class="icon-file-upload"></i>Yükle</button>\n' +
    '                <button class="clear clear-all"><i class="icon-cross3"></i> Temizle</button>\n' +
    '            </div>\n' +
    '        </div>\n' +
    '    </div>\n' +
    '    <div class="card-body">\n' +
    '        <div class="previewarea">\n' +
    '            <div class="row">' +
    '            </div>' +
    '        </div>\n' +
    '       <div class="itemarea">\n' +
    '        </div>\n' +
    '    </div>\n' +
    ' </div>';

var $uploader_multipleImagePreviewElement = '\n' +
    '<div class="col-sm-3 col-md-2 col-lg-1 ">' +
    '    <div class="card multielement" id="<%:fid%>">\n' +
    '        <div class="card-img-actions m-1">\n' +
    '            <img class="card-img img-fluid" src="<%:preview%>" alt="">\n' +
    '            <div class="card-img-actions-overlay card-img">\n' +
    '                <a href="#" class="btn btn-outline bg-white text-white border-white border-2 btn-icon rounded-round legitRipple delete-btn">\n' +
    '                    <i class="icon-bin"></i>\n' +
    '                </a>\n' +
    '            </div>\n' +
    '        </div>\n' +
    '        <div class="indicatorarea" style="display: none; width: 75%; margin: 0 auto;">\n' +
    '                <div class="progress" style="height: 0.125rem; position: relative; width: 100%;margin: 0 auto;margin-top: -25px;">\n' +
    '                    <div class="progress-bar progress-bar-warning progress-bar-striped" style="width: 0%;">\n' +
    '                        <span class="sr-only">0% complete</span>\n' +
    '                    </div>\n' +
    '                </div>\n' +
    '         </div>\n' +
    '    </div>' +
    '</div>'
//endregion

//region MultiImageManager
var $uploader_multiImageManagerTemplate = '' +
    '<div class="col-md-12">\n' +
    '    <div class="panel panel-default">\n' +
    '        <div class="panel-heading">\n' +
    '            <blockquote>Sürükle - Bırak yöntemiyle fotoğrafların sıralamasını değiştirebilirsiniz.</blockquote>\n' +
    '        </div>\n' +
    '        <div class="table-responsive">\n' +
    '            <table class="multi-image-manager-table table table-bordered table-hover responsive"\n' +
    '                   data-orderurl= "<%:orderurl%>"    \n' +
    '                   data-updateurl="<%:updateurl%>"   \n' +
    '                   data-deleteurl="<%:deleteurl%>"   \n' +
    '                   data-func="<%:function%>">             \n' +
    '                <tbody class="sortable">\n' +
    '                </tbody>\n' +
    '            </table>\n' +
    '        </div>\n' +
    '    </div>\n' +
    '</div>';


var $uploader_multiImageManagerRow = '' +
    '<tr class="sortable-item" data-id="<%:imageid%>">\n' +
    '    <td class="text-center sort-handler" style="width: 40px;">\n' +
    '        <i class="icon-sort text-danger-400"></i>\n' +
    '    </td>\n' +
    '    <td style="width: 270px;">\n' +
    '        <div style="max-width: 250px;">\n' +
    '            <img src="<%:imageurl%>" style="max-width: 100%; max-height: 250px;" alt="">\n' +
    '        </div>\n' +
    '    </td>\n' +
    '     <td class="galleryimagecaptionwrapper">\n' +
    '         <input name="galleryimagetitle" class="form-control galleryimagetitle" placeholder="Başlık" value="<%:pivottitle%>"/>\n' +
    '         <div class="galleryimagecaptioneditor"></div>'+
    '         <textarea style="display: none;" name="galleryimagecaption" class="form-control galleryimagecaption" placeholder="Açıklama"><%:pivotcaption%></textarea>\n' +
    '     </td>\n' +
    '    <td class="text-center" style="width:120px;">\n' +
    '        <button class="btn btn-icon btn-primary btn-photo-update" data-event="update"">\n' +
    '            <i class=" icon-floppy-disk" style="margin-right:0;"></i>\n' +
    '        </button>\n' +
    '        <button class="btn btn-icon btn-danger btn-photo-remove" data-event="destroy"">\n' +
    '            <i class=" icon-trash" style="margin-right:0;"></i>\n' +
    '        </button>\n' +
    '    </td>\n' +
    '</tr>\n';
//endregion

//endregion

function getPlaceHolder(width = 100, height = 100, text = '') {
    return $uploaderSettings.placeholderUrl + '?width=' + width + '&height=' + height + '&text=' + text;
}

//INITIALIZE HTML
$(function () {
    var $uploaderElements = $('hr.n-uploader');
    $.each($uploaderElements, function (index, uploader) {

        var $u = $(uploader);

        var $type = $u.data('type') || 'doc';
        var $multiple = $u.data('multiple') || false;

        var $config = $u.data('config');

        var $function = $u.data('function');

        var $key = $u.data('key');
        var $title = $u.data('title') || 'Dosya';
        var $titleInfo = '';

        var $placeHolderUrl = getPlaceHolder('', '', $title);
        var $placeHolderFileName = $title;

        var $orderurl = $u.data('orderurl') || null;
        var $updateurl = $u.data('updateurl') || null;
        var $deleteurl = $u.data('deleteurl') || null;

        var $items = $u.data('items') || [];


        if ($config) {
            var $pwidth = '';
            var $pheight = '';
            if ($config.width) {
                $pwidth = $config.width
            }
            if ($config.height) {
                $pheight = $config.height
            }

            $placeHolderUrl = getPlaceHolder($pwidth, $pheight, $title);
            $titleInfo = (($pwidth && $pheight) ? ($pwidth + ' x ' + $pheight) : '');

        }
        if ($type == 'img') {
            if ($multiple) {
                var $uTemplate = $.templates($uploader_multiImageUploadTemplate);
                var $uTemplateData = {
                    key: $key,
                    function: $function,
                    title: $title,
                    titleinfo: $titleInfo,
                    previewurl: $preview,
                    previewwidth: $pwidth || null,
                    previewheight: $pheight || null

                };

                var $uHtml = $uTemplate.render($uTemplateData);
                $u.replaceWith($uHtml);
                var $newU = $('div.card.n-upload.' + $key + '-uploader');

                if ($items.length) {
                    var $uManagerTemplate = $.templates($uploader_multiImageManagerTemplate);
                    var $uManagerTemplateData = {
                        name: $title,
                        key: $key,
                        function: $function,
                        orderurl: $orderurl || null,
                        updateurl: $updateurl || null,
                        deleteurl: $deleteurl || null,
                        func: $key,
                    }
                    var $uManagerHtml = $uManagerTemplate.render($uManagerTemplateData);
                    $($uManagerHtml).appendTo($newU.find('div.itemarea'));

                    $.each($items, function (key, val) {
                        $rowTemplate = $.templates($uploader_multiImageManagerRow);
                        $rowData = {
                            imageid: val.id,
                            imageurl: val.url,
                            pivottitle: val.pivot.title,
                            pivotcaption: val.pivot.caption,
                        }
                        var $rowHtml = $rowTemplate.render($rowData);
                        $($rowHtml).appendTo($newU.find('table'));

                    });
                }


            } else {

                var $preview = (($u.data('preview') != '') ? $u.data('preview') : $placeHolderUrl);

                var $uTemplate = $.templates($uploader_singleImageUploadTemplate);
                var $uTemplateData = {
                    key: $key,
                    title: $title,
                    titleinfo: $titleInfo,
                    previewurl: $preview,
                    previewwidth: $pwidth || null,
                    previewheight: $pheight || null,

                }
                var $uHtml = $uTemplate.render($uTemplateData);
                $u.replaceWith($uHtml);


            }
        } else if ($type == 'doc') {

            var $preview = (($u.data('preview') != '') ? $u.data('preview') : $placeHolderFileName);

            var $uTemplate = $.templates($uploader_singleFileUploadTemplate);
            var $uTemplateData = {
                key: $key,
                function: $function,
                title: $title,
                titleinfo: $titleInfo,
                filename: $preview
            }
            var $uHtml = $uTemplate.render($uTemplateData);
            $u.replaceWith($uHtml);

        } else if ($type == 'vid') {

        }

        $u = $('div.card.n-upload.' + $key + '-uploader');
        $u.on('click', 'button.upload', function (e) {
            e.preventDefault();
            e.stopPropagation();
            $u.find('input.fileuploader').click();
        })

        $u.find('input.fileuploader').on('change', function (event) {
            window.$uploader[$key] = [];
            window.$uploader[$key] = event.target.files;

            if (!$multiple) {
                _uploadSingleFile($key, $type);
            } else {
                _startMultiFile($key, $type);
            }
        })

        $u.find('button.btn-photo-update').click(function (event) {
            event.preventDefault();
            _updateMultiImageManagerItem($(this));
        });
        $u.find('button.btn-photo-remove').click(function (event) {
            event.preventDefault();
            _deleteMultiImageManagerItem($(this));
        });



        $u.find('tbody.sortable').sortable({
            cursor: "move",
            helper: 'clone',
            handler: 'sort-handler',
            tolerance: 'pointer',
            cancel: ':input,button,.contenteditable',
            update: function (event, ui) {
                _orderMultiImageManagerItem($(this));
            }
        });

        $u.on('click', 'button.clear', function (e) {
            e.preventDefault();
            e.stopPropagation();
            _deleteSingleFile($key, $type, $title);
        })

        $u.on('click', 'button.clear-all', function (e) {
            e.preventDefault();
            e.stopPropagation();
            _clearMultiFile($key, $type);
        })

    })

    if(pell !== undefined){
        var editorElements = $('.galleryimagecaptionwrapper');
        $.each(editorElements,function(key,val){
            var editor = $(val).find('.galleryimagecaptioneditor').first();
            var content = $(val).find('.galleryimagecaption').first();
            var p_editor = pell.init({
                element: editor[0] ,
                onChange: html => {$(content).val(html)},
                defaultParagraphSeparator: 'div',
                styleWithCSS: false,
                actions: [
                    'bold',
                    'italic',
                    'underline',
                    'link'
                ],
                classes: {
                    actionbar: 'pell-actionbar',
                    button: 'pell-button',
                    content: 'pell-content',
                    selected: 'pell-button-selected'
                }
            });

            p_editor.content.innerHTML = content.val();

        })

    }
})

//region Single Element
function _uploadSingleFile(_key, _type) {
    var data = new FormData();

    $.each(window.$uploader[_key], function (key, value) {
        data.append('file', value);
    });

    data.append('_token', $('input[name=_token]').val());
    data.append('skey', $('input[name=_skey]').val());
    data.append('key', _key);
    data.append('type', _type);

    var axiosConfig = {
        headers: {
            'Content-Type': 'multipart/form-data'
        },
        onUploadProgress: function (progressEvent) {
            var percentCompleted = Math.floor((progressEvent.loaded * 100) / progressEvent.total);

            var $indicator = $('div.card.n-upload.' + _key + '-uploader').find('.indicatorarea');
            $indicator.show();
            $indicator.find('.progress-bar').css('width', percentCompleted + '%');
            $indicator.find('.progress-bar span').html(percentCompleted + '%');
            if (percentCompleted == 100) {
                $indicator.hide()
            }
        }
    };
    axios
        .post($uploaderSettings.singleFileUploadUrl, data, axiosConfig)
        //Get Response
        .then(function (response) {
            var data = response.data;
            var uuid = data[Object.keys(data)[0]].uuid;
            var clname = data[Object.keys(data)[0]].clientname || '';

            if (_type == 'img') {
                setTimeout(_getSingleFilePreview(_key, _type, uuid), 500);
            } else if (_type == 'doc') {
                var $preview = $('div.card.n-upload.' + _key + '-uploader').find('.filearea span');
                $preview.html(clname);
            }
        });

}

function _getSingleFilePreview(_key, _type, id) {

    var data = new FormData();

    data.append('_token', $('input[name=_token]').val());
    data.append('skey', $('input[name=_skey]').val());
    if (id !== undefined) {
        data.append('id', id);
    }
    data.append('key', _key);
    data.append('type', _type);

    var axiosConfig = {
        headers: {
            'Content-Type': 'multipart/form-data'
        }
    };

    axios
        .post($uploaderSettings.singleFilePreviewUrl, data, axiosConfig)
        //Get Response
        .then(function (response) {
            var data = response.data;
            if (data !== null) {
                if (Object.prototype.hasOwnProperty.call(data, 'uuid') && Object.prototype.hasOwnProperty.call(data, 'preview')) {
                    var $preview = $('div.card.n-upload.' + _key + '-uploader').find('.previewarea img');
                    $($preview).attr('src', data.preview);
                    // $('img.' + _key + '-thumb').css('max-width', '');
                    // $('img.' + _key + '-thumb').css('max-height', '');
                } else {
                    // var _id = Object.keys(data)[0];
                    // setTimeout(_getSinglePreview(_key,_id),500);
                }

            }
        });


}

function _deleteSingleFile(_key, _type, _title) {

    var $title = _title || 'Resim'
    var $key = _key || ''
    var data = new FormData();

    data.append('_token', $('input[name=_token]').val());
    data.append('skey', $('input[name=_skey]').val());
    data.append('key', _key);
    data.append('type', _type);

    var axiosConfig = {
        headers: {
            'Content-Type': 'multipart/form-data'
        }
    };

    axios
        .post($uploaderSettings.singleFileDeleteUrl, data, axiosConfig)
        .then(function (response) {
            var data = response.data;
            if (data !== null) {
                if (_type == 'img') {
                    var $preview = $('div.card.n-upload.' + $key + '-uploader').find('.previewarea img');
                    $($preview).attr('src', getPlaceHolder('', '', $title));
                } else if (_type == 'doc') {
                    var $preview = $('div.card.n-upload.' + $key + '-uploader').find('.filearea span');
                    $preview.html($title);
                }
            }
        });


}

//endregion

//region Ajax Manager
var ajaxManager = (function () {
    var requests = [];

    return {
        //ADD REQUEST
        addReq: function (request, callback, failed, upload) {
            requests.push({
                request: (request || ({url: '/', data: {}})),
                callback: (callback || function (result) {
                }),
                failed: (failed || function (error) {
                }),
                upload: (upload || function (progressEvent) {
                })
            });

        },
        run: function () {
            var self = this;

            if (requests.length) {
                var axiosConfig = {
                    headers: {'Content-Type': 'multipart/form-data'},
                    onUploadProgress: requests[0].upload
                };
                axios
                    .post((requests[0].request.url || '/'), (requests[0].request.data || {}), axiosConfig)
                    .then(function (response) {
                        requests[0].callback(response);
                        requests.shift();
                        self.run.apply(self, []);
                    })
                    .catch(function (error) {
                        requests[0].failed(error);
                        requests.shift();
                        self.run.apply(self, []);
                    });

            } else {
                self.tid = setTimeout(function () {
                    self.run.apply(self, []);
                }, 1000);
            }
        },
        stop: function () {
            requests = [];
            clearTimeout(this.tid);
        }
    };
}());
//Ajax Manager ı başlatıyoruz
ajaxManager.run();
//endregion

//region Multi Element
function _startMultiFile(_key, _type) {
    if (_key === undefined) {
        return false;
    }

    //upload edilecek dosyaların bir klonunu al
    var uploadQueue = window.$uploader[_key];


    if (uploadQueue.length > 0) {
        //Each item ı işleme sok
        $.each(uploadQueue, function (filekey, uploadFile) {

            // Generate unique Template ID
            var _templateID = guid()

            // Item Template ini
            _addItemToArea(_key, _templateID);

            //Upload Requestini
            var requestObject = _uploadMultiFile(_key, _type, uploadFile, _templateID)
            ajaxManager.addReq(requestObject.request, requestObject.callback, requestObject.failed, requestObject.upload);
        })

    } else {
        return false;
    }


}

function _addItemToArea(_key, _id) {
    //Add image placeholder to area
    var $elementTemplate = $.templates($uploader_multipleImagePreviewElement);
    var $elementTemplateData = {
        fid: _id,
        preview: getPlaceHolder(100, 100, 'item')
    }
    var $elementHtml = $elementTemplate.render($elementTemplateData);
    var $elementArea = $('div.card.n-upload.' + _key + '-uploader').find('.previewarea .row');
    $elementArea.append($elementHtml);


}

function _removeItemFromArea(_templateID, _mediaID) {
    if (_templateID !== undefined) {
        $('div#' + _templateID).parent().remove();
    }

    if (_mediaID !== undefined) {

        $("div[data-media='" + _mediaID + "']").parent().remove();
    }

}

function _uploadMultiFile(_key, _type, _file, _templateID) {

    var data = new FormData();

    //Collect Form Data
    data.append('_token', $('input[name=_token]').val());
    data.append('skey', $('input[name=_skey]').val());

    data.append('type', _type);
    data.append('key', _key);
    data.append('file', _file);
    data.append('templateID', _templateID);

    var failCalllback = function (error) {
        console.log(error);
    }
    var successCallback = function (response) {
        var rdata = response.data
        var uuid = null
        $.each(rdata, function (key, entry) {
            if (entry.templateID == _templateID) {
                uuid = entry.uuid;
            }
        });
        //Ajax Manager a Preview için request i ekliyoruz
        var previewObject = _getMultiFilePreview(_key, _type, uuid, _templateID)
        ajaxManager.addReq(previewObject.request, previewObject.callback, previewObject.failed, previewObject.upload);
    }
    var upload = function (progressEvent) {
        var percentCompleted = Math.floor((progressEvent.loaded * 100) / progressEvent.total);

        var $indicator = $('.multielement#' + _templateID + ' .indicatorarea');
        $indicator.show();
        $indicator.find('.progress-bar').css('width', percentCompleted + '%');
        $indicator.find('.progress-bar span').html(percentCompleted + '%');
        if (percentCompleted == 100) {
            $indicator.hide()
        }
    }
    var request = {
        url: $uploaderSettings.singleFileUploadUrl,
        data: data
    }

    return {
        request: request,
        callback: successCallback,
        failed: failCalllback,
        upload: upload
    }
}

function _getMultiFilePreview(_key, _type, _id, _templateID) {

    var data = new FormData();

    //Collect Form Data
    data.append('_token', $('input[name=_token]').val());
    data.append('skey', $('input[name=_skey]').val());

    data.append('type', _type);
    data.append('key', _key);
    data.append('templateID', _templateID);

    if (_id !== undefined) {
        data.append('id', _id);
    }

    var failCalllback = function (error) {
        console.log(error);
    }
    var successCallback = function (response) {
        var rdata = response.data
        if (Object.prototype.hasOwnProperty.call(rdata, 'preview') && Object.prototype.hasOwnProperty.call(rdata, 'uuid')) {
            var $elem = $('.multielement#' + _templateID);
            $elem.find('img.card-img').attr('src', rdata.preview);
            $elem.find('div.card-img-actions-overlay').children('a.delete-btn').attr('data-uuid', rdata.uuid)
            $elem.find('div.card-img-actions-overlay').children('a.delete-btn').attr('data-key', _key)
            $elem.find('div.card-img-actions-overlay').children('a.delete-btn').attr('data-type', _type)
        } else {
            _removeItemFromArea(_templateID);
        }
    }
    var upload = function (progressEvent) {
    }
    var request = {
        url: $uploaderSettings.singleFilePreviewUrl,
        data: data
    }

    return {
        request: request,
        callback: successCallback,
        failed: failCalllback,
        upload: upload
    }
}

function _deleteMultiFile(_key, _type, _id, _templateID) {
    var data = new FormData();

    data.append('_token', $('input[name=_token]').val());
    data.append('skey', $('input[name=_skey]').val());

    data.append('key', _key);
    data.append('id', _id);
    data.append('type', _type);

    var failCalllback = function (error) {
        console.log(error);
    }
    var successCallback = function (response) {
        var rdata = response.data
        _removeItemFromArea(_templateID);
    }
    var upload = function (progressEvent) {
    }

    var request = {
        url: $uploaderSettings.singleFileDeleteUrl,
        data: data
    }

    return {
        request: request,
        callback: successCallback,
        failed: failCalllback,
        upload: upload
    }
}

function _clearMultiFile(_key, _type) {
    var data = new FormData();

    data.append('_token', $('input[name=_token]').val());
    data.append('skey', $('input[name=_skey]').val());

    data.append('type', _type);
    data.append('key', _key);

    var failCalllback = function (error) {
        console.log(error);
    }
    var successCallback = function (response) {
        var rdata = response.data
        var $elementArea = $('div.card.n-upload.' + _key + '-uploader').find('.previewarea .row');
        $elementArea.html('');
    }
    var upload = function (progressEvent) {
    }
    var request = {
        url: $uploaderSettings.multiFileRemoveAllUrl,
        data: data
    }

    ajaxManager.addReq(request, successCallback, failCalllback, upload);
}

$(document).on('click', 'a.delete-btn', function (event) {
    event.preventDefault();
    event.stopPropagation();

    var uuid = $(this).attr('data-uuid');
    var key = $(this).attr('data-key');
    var type = $(this).attr('data-type');
    var id = $(this).parent().parent().parent().attr('id')

    var requestObject = _deleteMultiFile(key, type, uuid, id)
    ajaxManager.addReq(requestObject.request, requestObject.callback, requestObject.failed, requestObject.upload);
});

function _updateMultiImageManagerItem(item) {
    var $inputContainer = $(item).closest('.sortable-item');
    var $tableContainer = $(item).closest('table');
    var itemID = $inputContainer.data("id");

    if (itemID !== undefined && parseInt(itemID) > 0) {

        var data = new FormData();

        data.append('_token', $('input[name=_token]').val());
        data.append('caption', $inputContainer.find("textarea.galleryimagecaption").val() || '');
        data.append('title', $inputContainer.find("input.galleryimagetitle").val() || '');
        data.append('source', $inputContainer.find("input.galleryimagesource").val() || '');
        data.append('func', $tableContainer.data("func") || 'multi');
        data.append('mediaId', itemID);

        var updateurl = $(item).closest('.multi-image-manager-table').data('updateurl');

        var failCalllback = function (error) {
            console.log(error);
        }
        var successCallback = function (response) {
            var rdata = response.data
            $(item).parent().parent().stop().css('background-color', 'black').animate({
                backgroundColor: "#2bce3e"
            }, 500);

        }
        var upload = function (progressEvent) {
        }
        var request = {
            url: updateurl,
            data: data
        }

        ajaxManager.addReq(request, successCallback, failCalllback, upload);

    } else {
        console.log("Bu item düzenlenemez. ID si mevcut değil");
    }
}

function _deleteMultiImageManagerItem(item) {
    var $inputContainer = $(item).closest('.sortable-item');
    var $tableContainer = $(item).closest('table');
    var itemID = $inputContainer.data("id");

    if (itemID !== undefined && parseInt(itemID) > 0) {
        var data = new FormData();
        data.append('_token', $('input[name=_token]').val());
        data.append('func', $tableContainer.data("func") || 'multi');
        data.append('mediaId', itemID);

        var deleteurl = $(item).closest('.multi-image-manager-table').data('deleteurl');


        var failCalllback = function (error) {
            console.log(error);
        }
        var successCallback = function (response) {
            var rdata = response.data
            $(item).closest('.sortable-item').remove();
        }
        var upload = function (progressEvent) {
        }
        var request = {
            url: deleteurl,
            data: data
        }

        ajaxManager.addReq(request, successCallback, failCalllback, upload);

    } else {
        console.log("Bu item düzenlenemez. ID si mevcut değil");
    }

}

function _orderMultiImageManagerItem(sortable_list) {
    var $this = $(sortable_list),
        start = 1,
        stack = {};

    $this.find('.sortable-item').each(function (e) {
        stack[$(this).data('id')] = $(this).index() + parseInt(start);
    });

    console.log(stack);

    var $tableContainer = $($this).closest('table');

    var data = new FormData();
    data.append('_token', $('input[name=_token]').val());
    data.append('func', $tableContainer.data("func") || 'multi');
    data.append('order', JSON.stringify(stack));


    var orderurl = $($this).closest('.multi-image-manager-table').data('orderurl');


    var failCalllback = function (error) {
        console.log(error);
    }
    var successCallback = function (response) {
        var rdata = response.data
        new Noty({
            text: 'Başarıyla kaydedildi',
            type: 'success',
            timeout: 5000
        }).show();
    }
    var upload = function (progressEvent) {
    }
    var request = {
        url: orderurl,
        data: data
    }

    ajaxManager.addReq(request, successCallback, failCalllback, upload);


}

//endregion

function guid() {
    function s4() {
        return Math.floor((1 + Math.random()) * 0x10000).toString(16).substring(1);
    }

    return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
}
