/* ------------------------------------------------------------------------------
 *
 *  # Template JS core
 *
 *  Includes minimum required JS code for proper template functioning
 *
 * ---------------------------------------------------------------------------- */

// Setup module
// ------------------------------

var App=(function() {
    //
    // Setup module components
    //

    // Transitions
    // -------------------------

    // Disable all transitions
    var _transitionsDisabled=function() {
        $("body").addClass("no-transitions");
    };

    // Enable all transitions
    var _transitionsEnabled=function() {
        $("body").removeClass("no-transitions");
    };

    // Sidebars
    // -------------------------

    //
    // On desktop
    //

    // Resize main sidebar
    var _sidebarMainResize=function() {
        // Flip 2nd level if menu overflows
        // bottom edge of browser window
        var revertBottomMenus=function() {
            $(".sidebar-main")
                .find(".nav-sidebar")
                .children(".nav-item-submenu")
                .hover(function() {
                    var totalHeight=0,
                        $this=$(this),
                        navSubmenuClass="nav-group-sub",
                        navSubmenuReversedClass="nav-item-submenu-reversed";

                    totalHeight+=$this
                        .find("." + navSubmenuClass)
                        .filter(":visible")
                        .outerHeight();
                    if($this.children("." + navSubmenuClass).length){
                        if(
                            $this.children("." + navSubmenuClass).offset().top +
                            $this
                                .find("." + navSubmenuClass)
                                .filter(":visible")
                                .outerHeight() >
                            document.body.clientHeight
                        ){
                            $this.addClass(navSubmenuReversedClass);
                        }else{
                            $this.removeClass(navSubmenuReversedClass);
                        }
                    }
                });
        };

        // If sidebar is resized by default
        if($("body").hasClass("sidebar-xs")){
            revertBottomMenus();
        }

        // Toggle min sidebar class
        $(".sidebar-main-toggle").on("click", function(e) {
            e.preventDefault();

            $("body")
            //.toggleClass("sidebar-xs")
                .toggleClass("sidebar-mobile-main");
            //.removeClass("sidebar-mobile-main");
            revertBottomMenus();
        });
    };

    // Toggle main sidebar
    var _sidebarMainToggle=function() {
        $(document).on("click", ".sidebar-main-hide", function(e) {
            e.preventDefault();
            $("body").toggleClass("sidebar-main-hidden");
        });
    };

    // Toggle secondary sidebar
    var _sidebarSecondaryToggle=function() {
        $(document).on("click", ".sidebar-secondary-toggle", function(e) {
            e.preventDefault();
            $("body").toggleClass("sidebar-secondary-hidden");
        });
    };

    // Show right, resize main
    var _sidebarRightMainToggle=function() {
        $(document).on("click", ".sidebar-right-main-toggle", function(e) {
            e.preventDefault();

            // Right sidebar visibility
            $("body").toggleClass("sidebar-right-visible");

            // If visible
            if($("body").hasClass("sidebar-right-visible")){
                // Make main sidebar mini
                //$("body").addClass("sidebar-xs");

                // Hide children lists if they are opened, since sliding animation adds inline CSS
                $(".sidebar-main .nav-sidebar")
                    .children(".nav-item")
                    .children(".nav-group-sub")
                    .css("display", "");
            }else{
                $("body").removeClass("sidebar-xs");
            }
        });
    };

    // Show right, hide main
    var _sidebarRightMainHide=function() {
        $(document).on("click", ".sidebar-right-main-hide", function(e) {
            e.preventDefault();

            // Opposite sidebar visibility
            $("body").toggleClass("sidebar-right-visible");

            // If visible
            if($("body").hasClass("sidebar-right-visible")){
                $("body").addClass("sidebar-main-hidden");
            }else{
                $("body").removeClass("sidebar-main-hidden");
            }
        });
    };

    // Toggle right sidebar
    var _sidebarRightToggle=function() {
        $(document).on("click", ".sidebar-right-toggle", function(e) {
            e.preventDefault();

            $("body").toggleClass("sidebar-right-visible");
        });
    };

    // Show right, hide secondary
    var _sidebarRightSecondaryToggle=function() {
        $(document).on("click", ".sidebar-right-secondary-toggle", function(e) {
            e.preventDefault();

            // Opposite sidebar visibility
            $("body").toggleClass("sidebar-right-visible");

            // If visible
            if($("body").hasClass("sidebar-right-visible")){
                $("body").addClass("sidebar-secondary-hidden");
            }else{
                $("body").removeClass("sidebar-secondary-hidden");
            }
        });
    };

    // Toggle content sidebar
    var _sidebarComponentToggle=function() {
        $(document).on("click", ".sidebar-component-toggle", function(e) {
            e.preventDefault();
            $("body").toggleClass("sidebar-component-hidden");
        });
    };

    //
    // On mobile
    //

    // Expand sidebar to full screen on mobile
    var _sidebarMobileFullscreen=function() {
        $(".sidebar-mobile-expand").on("click", function(e) {
            e.preventDefault();
            var $sidebar=$(this).parents(".sidebar"),
                sidebarFullscreenClass="sidebar-fullscreen";

            if(!$sidebar.hasClass(sidebarFullscreenClass)){
                $sidebar.addClass(sidebarFullscreenClass);
            }else{
                $sidebar.removeClass(sidebarFullscreenClass);
            }
        });
    };

    // Toggle main sidebar on mobile
    var _sidebarMobileMainToggle=function() {
        $(".sidebar-mobile-main-toggle").on("click", function(e) {
            e.preventDefault();
            $("body")
                .toggleClass("sidebar-mobile-main")
                .removeClass("sidebar-mobile-secondary sidebar-mobile-right");

            if($(".sidebar-main").hasClass("sidebar-fullscreen")){
                $(".sidebar-main").removeClass("sidebar-fullscreen");
            }
        });
    };

    // Toggle secondary sidebar on mobile
    var _sidebarMobileSecondaryToggle=function() {
        $(".sidebar-mobile-secondary-toggle").on("click", function(e) {
            e.preventDefault();
            $("body")
                .toggleClass("sidebar-mobile-secondary")
                .removeClass("sidebar-mobile-main sidebar-mobile-right");

            // Fullscreen mode
            if($(".sidebar-secondary").hasClass("sidebar-fullscreen")){
                $(".sidebar-secondary").removeClass("sidebar-fullscreen");
            }
        });
    };

    // Toggle right sidebar on mobile
    var _sidebarMobileRightToggle=function() {
        $(".sidebar-mobile-right-toggle").on("click", function(e) {
            e.preventDefault();
            $("body")
                .toggleClass("sidebar-mobile-right")
                .removeClass("sidebar-mobile-main sidebar-mobile-secondary");

            // Hide sidebar if in fullscreen mode on mobile
            if($(".sidebar-right").hasClass("sidebar-fullscreen")){
                $(".sidebar-right").removeClass("sidebar-fullscreen");
            }
        });
    };

    // Toggle component sidebar on mobile
    var _sidebarMobileComponentToggle=function() {
        $(".sidebar-mobile-component-toggle").on("click", function(e) {
            e.preventDefault();
            $("body").toggleClass("sidebar-mobile-component");
        });
    };

    // Navigations
    // -------------------------

    // Sidebar navigation
    var _navigationSidebar=function() {
        // Define default class names and options
        var navClass="nav-sidebar",
            navItemClass="nav-item",
            navItemOpenClass="nav-item-open",
            navLinkClass="nav-link",
            navSubmenuClass="nav-group-sub",
            navSlidingSpeed=250;

        // Configure collapsible functionality
        $("." + navClass).each(function() {
            $(this)
                .find("." + navItemClass)
                .has("." + navSubmenuClass)
                .children("." + navItemClass + " > " + "." + navLinkClass)
                .not(".disabled")
                .on("click", function(e) {
                    e.preventDefault();

                    // Simplify stuff
                    var $target=$(this),
                        $navSidebarMini=$(".sidebar-xs")
                            .not(".sidebar-mobile-main")
                            .find(".sidebar-main ." + navClass)
                            .children("." + navItemClass);

                    // Collapsible
                    if($target.parent("." + navItemClass).hasClass(navItemOpenClass)){
                        $target
                            .parent("." + navItemClass)
                            .not($navSidebarMini)
                            .removeClass(navItemOpenClass)
                            .children("." + navSubmenuClass)
                            .slideUp(navSlidingSpeed);
                    }else{
                        $target
                            .parent("." + navItemClass)
                            .not($navSidebarMini)
                            .addClass(navItemOpenClass)
                            .children("." + navSubmenuClass)
                            .slideDown(navSlidingSpeed);
                    }

                    // Accordion
                    if($target.parents("." + navClass).data("nav-type") == "accordion"){
                        $target
                            .parent("." + navItemClass)
                            .not($navSidebarMini)
                            .siblings(":has(." + navSubmenuClass + ")")
                            .removeClass(navItemOpenClass)
                            .children("." + navSubmenuClass)
                            .slideUp(navSlidingSpeed);
                    }
                });
        });

        // Disable click in disabled navigation items
        $(document).on("click", "." + navClass + " .disabled", function(e) {
            e.preventDefault();
        });

        // Scrollspy navigation
        $(".nav-scrollspy")
            .find("." + navItemClass)
            .has("." + navSubmenuClass)
            .children("." + navItemClass + " > " + "." + navLinkClass)
            .off("click");
    };

    // Navbar navigation
    var _navigationNavbar=function() {
        // Prevent dropdown from closing on click
        $(document).on("click", ".dropdown-content", function(e) {
            e.stopPropagation();
        });

        // Disabled links
        $(".navbar-nav .disabled a, .nav-item-levels .disabled").on(
            "click",
            function(e) {
                e.preventDefault();
                e.stopPropagation();
            }
        );

        // Show tabs inside dropdowns
        $(".dropdown-content a[data-toggle=\"tab\"]").on("click", function(e) {
            $(this).tab("show");
        });
    };

    // Components
    // -------------------------

    // Tooltip
    var _componentTooltip=function() {
        // Initialize
        $("[data-popup=\"tooltip\"]").tooltip();

        // Demo tooltips, remove in production
        var demoTooltipSelector="[data-popup=\"tooltip-demo\"]";
        if($(demoTooltipSelector).is(":visible")){
            $(demoTooltipSelector).tooltip("show");
            setTimeout(function() {
                $(demoTooltipSelector).tooltip("hide");
            }, 2000);
        }
    };

    // Popover
    var _componentPopover=function() {
        $("[data-popup=\"popover\"]").popover();
    };

    // Card actions
    // -------------------------

    // Reload card (uses BlockUI extension)
    var _cardActionReload=function() {
        $(".card [data-action=reload]:not(.disabled)").on("click", function(e) {
            e.preventDefault();
            var $target=$(this),
                block=$target.closest(".card");

            // Block card
            $(block).block({
                message: "<i class=\"icon-spinner2 spinner\"></i>",
                overlayCSS: {
                    backgroundColor: "#fff",
                    opacity: 0.8,
                    cursor: "wait",
                    "box-shadow": "0 0 0 1px #ddd"
                },
                css: {
                    border: 0,
                    padding: 0,
                    backgroundColor: "none"
                }
            });

            // For demo purposes
            window.setTimeout(function() {
                $(block).unblock();
            }, 2000);
        });
    };

    // Collapse card
    var _cardActionCollapse=function() {
        var $cardCollapsedClass=$(".card-collapsed");

        // Hide if collapsed by default
        $cardCollapsedClass
            .children(".card-header")
            .nextAll()
            .hide();

        // Rotate icon if collapsed by default
        $cardCollapsedClass.find("[data-action=collapse]").addClass("rotate-180");

        // Collapse on click
        $(".card [data-action=collapse]:not(.disabled)").on("click", function(e) {
            var $target=$(this),
                slidingSpeed=150;

            e.preventDefault();
            $target.parents(".card").toggleClass("card-collapsed");
            $target.toggleClass("rotate-180");
            $target
                .closest(".card")
                .children(".card-header")
                .nextAll()
                .slideToggle(slidingSpeed);
        });
    };

    // Remove card
    var _cardActionRemove=function() {
        $(".card [data-action=remove]").on("click", function(e) {
            e.preventDefault();
            var $target=$(this),
                slidingSpeed=150;

            // If not disabled
            if(!$target.hasClass("disabled")){
                $target.closest(".card").slideUp({
                    duration: slidingSpeed,
                    start: function() {
                        $target.addClass("d-block");
                    },
                    complete: function() {
                        $target.remove();
                    }
                });
            }
        });
    };

    // Card fullscreen mode
    var _cardActionFullscreen=function() {
        $(".card [data-action=fullscreen]").on("click", function(e) {
            e.preventDefault();

            // Define vars
            var $target=$(this),
                cardFullscreen=$target.closest(".card"),
                overflowHiddenClass="overflow-hidden",
                collapsedClass="collapsed-in-fullscreen",
                fullscreenAttr="data-fullscreen";

            // Toggle classes on card
            cardFullscreen.toggleClass("fixed-top h-100 rounded-0");

            // Configure
            if(!cardFullscreen.hasClass("fixed-top")){
                $target.removeAttr(fullscreenAttr);
                cardFullscreen.children("." + collapsedClass).removeClass("show");
                $("body").removeClass(overflowHiddenClass);
                $target
                    .siblings(
                        "[data-action=move], [data-action=remove], [data-action=collapse]"
                    )
                    .removeClass("d-none");
            }else{
                $target.attr(fullscreenAttr, "active");
                cardFullscreen
                    .removeAttr("style")
                    .children(".collapse:not(.show)")
                    .addClass("show " + collapsedClass);
                $("body").addClass(overflowHiddenClass);
                $target
                    .siblings(
                        "[data-action=move], [data-action=remove], [data-action=collapse]"
                    )
                    .addClass("d-none");
            }
        });
    };

    // Misc
    // -------------------------

    // Dropdown submenus. Trigger on click
    var _dropdownSubmenu=function() {
        // All parent levels require .dropdown-toggle class
        $(".dropdown-menu")
            .find(".dropdown-submenu")
            .not(".disabled")
            .find(".dropdown-toggle")
            .on("click", function(e) {
                e.stopPropagation();
                e.preventDefault();

                // Remove "show" class in all siblings
                $(this)
                    .parent()
                    .siblings()
                    .removeClass("show")
                    .find(".show")
                    .removeClass("show");

                // Toggle submenu
                $(this)
                    .parent()
                    .toggleClass("show")
                    .children(".dropdown-menu")
                    .toggleClass("show");

                // Hide all levels when parent dropdown is closed
                $(this)
                    .parents(".show")
                    .on("hidden.bs.dropdown", function(e) {
                        $(".dropdown-submenu .show, .dropdown-submenu.show").removeClass(
                            "show"
                        );
                    });
            });
    };

    // Header elements toggler
    var _headerElements=function() {
        // Toggle visible state of header elements
        $(".header-elements-toggle").on("click", function(e) {
            e.preventDefault();
            $(this)
                .parents("[class*=header-elements-]")
                .find(".header-elements")
                .toggleClass("d-none");
        });

        // Toggle visible state of footer elements
        $(".footer-elements-toggle").on("click", function(e) {
            e.preventDefault();
            $(this)
                .parents(".card-footer")
                .find(".footer-elements")
                .toggleClass("d-none");
        });
    };

    //
    // Return objects assigned to module
    //

    return {
        // Disable transitions before page is fully loaded
        initBeforeLoad: function() {
            _transitionsDisabled();
        },

        // Enable transitions when page is fully loaded
        initAfterLoad: function() {
            _transitionsEnabled();
        },

        // Initialize all sidebars
        initSidebars: function() {
            // On desktop
            _sidebarMainResize();
            _sidebarMainToggle();
            _sidebarSecondaryToggle();
            _sidebarRightMainToggle();
            _sidebarRightMainHide();
            _sidebarRightToggle();
            _sidebarRightSecondaryToggle();
            _sidebarComponentToggle();

            // On mobile
            _sidebarMobileFullscreen();
            _sidebarMobileMainToggle();
            _sidebarMobileSecondaryToggle();
            _sidebarMobileRightToggle();
            _sidebarMobileComponentToggle();
        },

        // Initialize all navigations
        initNavigations: function() {
            _navigationSidebar();
            _navigationNavbar();
        },

        // Initialize all components
        initComponents: function() {
            _componentTooltip();
            _componentPopover();
        },

        // Initialize all card actions
        initCardActions: function() {
            _cardActionReload();
            _cardActionCollapse();
            _cardActionRemove();
            _cardActionFullscreen();
        },

        // Dropdown submenu
        initDropdownSubmenu: function() {
            _dropdownSubmenu();
        },

        initHeaderElementsToggle: function() {
            _headerElements();
        },

        // Initialize core
        initCore: function() {
            App.initSidebars();
            App.initNavigations();
            App.initComponents();
            App.initCardActions();
            App.initDropdownSubmenu();
            App.initHeaderElementsToggle();
        }
    };
})();


// Initialize module
// ------------------------------

// When content is loaded
document.addEventListener("DOMContentLoaded", () => {
    App.initBeforeLoad();
    App.initCore();
});

// When page is fully loaded
window.addEventListener("load", () => {
    App.initAfterLoad();
});

//Activate Ripple
window.addEventListener("load", () => {
    // Ripple effect
    $(".ripple-dark:not(.disabled), .sp-replacer, .list-group-item-action:not(.disabled), .ripple-light:not(.disabled), .btn:not(.disabled):not(.multiselect.btn-light):not(.file-drag-handle), .nav-link:not(.disabled), .navbar-nav-link:not(.disabled), .sidebar-user-material-footer > a, .select2-selection--single[class*=bg-], .wizard > .actions a, .ui-button:not(.ui-dialog-titlebar-close):not(.ui-selectmenu-button), .ui-controlgroup .ui-selectmenu-button, .ui-tabs-anchor:not(.ui-state-disabled), .plupload_button:not(.plupload_disabled), .fc-button, .page-item:not(.disabled) > .page-link")
        .ripple({
            dragging: false,
            adaptPos: false,
            scaleMode: false
        });
});

$(function () {
    // Button with spinner
    /*Ladda.bind('.btn-ladda', {
          dataSpinnerSize: 16,
          timeout: 10000
      });

      Ladda.bind('.btn-ladda-spinner', {
          dataSpinnerSize: 16,
          timeout: 2000
      });*/

    $("a.show-btn:not(.disabled)").ripple({
        dragging: false,
        adaptPos: false,
        scaleMode: false
    });
    $("a.show-btn:not(.disabled)").tooltip({
        title: "Görüntüle",
        placement: "top"
    });

    $("a.publish-btn:not(.disabled)").ripple({
        dragging: false,
        adaptPos: false,
        scaleMode: false
    });
    $("a.publish-btn:not(.disabled)").tooltip({
        title: "Yayın",
        placement: "top"
    });

    $("a.edit-btn:not(.disabled)").ripple({
        dragging: false,
        adaptPos: false,
        scaleMode: false
    });
    $("a.edit-btn:not(.disabled)").tooltip({
        title: "Düzenle",
        placement: "top"
    });

    $("a.delete-btn:not(.disabled)").ripple({
        dragging: false,
        adaptPos: false,
        scaleMode: false
    });
    $("a.delete-btn:not(.disabled)").tooltip({
        title: "Sil",
        placement: "top"
    });
});

// DELETE
$(function () {
    $("a.delete-btn").click(function (event) {
        //prevent Things
        event.preventDefault();
        event.stopPropagation();

        //Is Disabled ?
        if ($(this).hasClass("disabled")) {
            return false;
        }

        //Prepare Ladda Button of this element
        var btn = $(this);
        $(btn)
            .attr("data-style", "slide-right")
            .addClass("btn-ladda")
            .addClass("btn-ladda-spinner")
            .addClass("disabled");
        var btnLadda = Ladda.create($(this).get(0));
        //Start Ladda
        btnLadda.start();

        //Deletion URL
        var $deletionURL = $(this).data("target");
        //Current Row
        var $deletionRow = $(this).closest("tr");
        //Create Sweet Alert;
        swal({
            buttons: {
                confirm: {
                    text: "Sil",
                    value: true,
                    visible: true,
                    className: "btn-danger",
                    closeModal: true
                },
                cancel: {
                    text: "İptal",
                    value: null,
                    visible: true,
                    className: "",
                    closeModal: true
                }
            },
            title: "Silme Onayı",
            text: "Bu nesneyi silmek istediğinizden emin misiniz?",
            icon: "warning",
            dangerMode: true
        })
        //Process Sweet Alert
            .then(function (isConfirm) {
                //Is SweetAlert Accepted ?
                if (isConfirm) {
                    //Send Delete Request
                    axios.delete($deletionURL, {}).then(function (response) {
                        //Response Data has result == true
                        if (response.data.result == true) {
                            //It deleted element
                            //Lets Remove row from table
                            $deletionRow.fadeOut(300, function () {
                                $(this).remove();
                            });
                            //Success Swal
                            swal("Silindi!", "Nesne başarıyla silindi", "success");
                        } else {
                            //It failed. Error Swal
                            swal("Silinemedi", "Nesne silinirken bir hata oluştu", "error");
                        }
                    });
                }

                //Remove All Ladda Style from this element and Stop progress
                btnLadda.stop(function () {
                    $(btn)
                        .removeAttr("data-style")
                        .removeClass("btn-ladda")
                        .removeClass("btn-ladda-spinner")
                        .removeClass("disabled");
                });
            });
    });
});

// BATCH DELETE
$(function () {
    //$('input[type="checkbox"].select-all-list, input[type="checkbox"].selection').uniform();

    $("input[type='checkbox'].select-all-list").click(function (e) {
        if ($(this).prop("checked")) {
            $("input[type='checkbox'].selection").prop("checked", true);
        } else {
            $("input[type='checkbox'].selection").prop("checked", false);
        }
        renderBatchDeleteButton();
    });

    $("input[type='checkbox'].selection").change(function () {
        renderBatchDeleteButton();
    });

    renderBatchDeleteButton();
});

function renderBatchDeleteButton() {
    if ($("input[type='checkbox'].selection:checked").length > 0) {
        $("a.batch-delete-item").css("display", "inline-block");
    } else {
        $("a.batch-delete-item").hide();
    }
}

$(function () {
    $("a.batch-delete-item").click(function (event) {
        //Prevent things
        event.preventDefault();
        event.stopPropagation();

        //Is Disabled ?
        if ($(this).hasClass("disabled")) {
            return false;
        }

        //Prepare Ladda Button of this element
        var btn = $(this);
        $(btn)
            .attr("data-style", "slide-right")
            .addClass("btn-ladda")
            .addClass("btn-ladda-spinner")
            .addClass("disabled");
        var btnLadda = Ladda.create($(this).get(0));
        //Start Ladda
        btnLadda.start();

        //Get Deletion List Items from checkbox's data-id attribute
        var deletionIDList = [];

        $.each($("input[type='checkbox'].selection:checked"), function (
            index,
            item
        ) {
            deletionIDList.push($(item).data("id"));
        });

        //If any item in Deletion List
        if (deletionIDList.length > 0) {
            //Deletion URL is buttons data-target attribute
            var $deletionURL = $(this).data("target");
            //Create Sweet Alert;
            swal({
                buttons: {
                    confirm: {
                        text: "Sil",
                        value: true,
                        visible: true,
                        className: "btn-danger",
                        closeModal: true
                    },
                    cancel: {
                        text: "İptal",
                        value: null,
                        visible: true,
                        className: "",
                        closeModal: true
                    }
                },
                title: "Silme Onayı",
                text: "Seçili nesneleri silmek istediğinizden emin misiniz?",
                icon: "warning",
                dangerMode: true
            })
            //Process Sweet Alert
                .then(function (isConfirm) {
                    //Is SweetAlert Accepted ?
                    if (isConfirm) {
                        //Send A Post With DeletionList
                        axios
                            .post($deletionURL, {
                                items: deletionIDList
                            })
                            //Get Response
                            .then(function (response) {
                                //Response Data has result == true
                                if (response.data.result == true) {
                                    //It deleted all all Elements
                                    //Lets Remove each row from table
                                    $.each(deletionIDList, function (index, item) {
                                        $(
                                            "input[type=\"checkbox\"][data-id=\"" + item + "\"].selection"
                                        )
                                            .closest("tr")
                                            .fadeOut(300, function () {
                                                $(this).remove();
                                            });
                                    });
                                    //Success Swal
                                    swal("Silindi!", "Nesneler başarıyla silindi", "success");
                                } else {
                                    //It failed. Error Swal
                                    swal(
                                        "Silinemedi",
                                        "Nesneler silinirken bir hata oluştu",
                                        "error"
                                    );
                                }
                            });
                    }

                    //Remove All Ladda Style from this element and Stop progress
                    btnLadda.stop(function () {
                        $(btn)
                            .removeAttr("data-style")
                            .removeClass("btn-ladda")
                            .removeClass("btn-ladda-spinner")
                            .removeClass("disabled");
                    });
                });
        }
    });
});

// PUBLISH & UNPUBLISH THINGS
$(function () {
    $("a.publish-btn").click(function (event) {
        //Prevent things
        event.preventDefault();
        event.stopPropagation();

        //Is Disabled ?
        if ($(this).hasClass("disabled")) {
            return false;
        }

        //Prepare Ladda Button of this element
        var btn = $(this);
        //Add Ladda Classes to Run Ladda
        $(btn)
            .attr("data-style", "slide-right")
            .addClass("btn-ladda")
            .addClass("btn-ladda-spinner")
            .addClass("disabled");
        //Bind Ladda
        var btnLadda = Ladda.create($(this).get(0));
        //Start Ladda
        btnLadda.start();

        //Set Icons
        var $publishedIcon = "icon-checkmark4";
        var $unpublishedIcon = "icon-cross2";

        //Set Result Action
        var $publishedAction = null;

        //Publish URL is buttons data-target attribute
        var $publishURL = $(this).data("target");
        var $currentPublished = $(this).hasClass("published");
        //Create Sweet Alert;
        swal({
            buttons: {
                confirm: {
                    text: "Evet",
                    value: true,
                    visible: true,
                    className: "btn-danger",
                    closeModal: true
                },
                cancel: {
                    text: "İptal",
                    value: null,
                    visible: true,
                    className: "",
                    closeModal: true
                }
            },
            title: "Onay",
            text:
                "Seçili nesneleri " +
                ($currentPublished ? "yayından kaldırmak" : "yayınlamak") +
                " istediğinizden emin misiniz?",
            icon: "warning",
            dangerMode: true
        })
        //Process Sweet Alert
            .then(function (isConfirm) {
                //Is SweetAlert Accepted ?
                if (isConfirm) {
                    //Send A Empty Post
                    axios
                        .post($publishURL)
                        //Get Response
                        .then(function (response) {
                            //Response data.result == true
                            if (response.data.result == true) {
                                //It succeeed
                                //Set Publish action data.action
                                $publishedAction = response.data.action || "unpublished";
                                //Success Swal
                                swal("Başarılı!", "İşlem başarılı", "success");
                            } else {
                                //Error Swal
                                swal("Başarısız", "Bir Hata oluştu", "error");
                            }
                            //Stop progress and Remove All Ladda Style & Status Icons from this element
                            btnLadda.stop(function () {
                                //Remove Ladda Components
                                $(btn)
                                    .removeAttr("data-style")
                                    .removeClass("btn-ladda")
                                    .removeClass("btn-ladda-spinner")
                                    .removeClass("disabled");
                                //Remove Publish Classes and icon
                                $(btn)
                                    .removeClass("unpublished")
                                    .removeClass("published")
                                    .html("");
                                //Create Icon and append it to button
                                var $btnIcon = $("<i></i>")
                                    .addClass(
                                        $publishedAction == "published"
                                            ? $publishedIcon
                                            : $unpublishedIcon
                                    )
                                    .appendTo($(btn));
                                //Set Result Class
                                $(btn).addClass($publishedAction);
                            });
                        });
                }
            });
    });
});

//Sortable
$(function () {
    $(".sortable-table tbody").sortable({
        placeholder: "table-sort-highlight",
        handle: ".table-column-sort"
    });
    $(".sortable-table tbody").disableSelection();
});

// FILTER BUTTON
$(function () {
    $(".filter-btn").click(function () {
        App._sidebarRightMainToggle();
    });
});

//Switches
function changeSwitchery(element, checked) {
    if (
        (element.is(":checked") && checked == false) ||
        (!element.is(":checked") && checked == true)
    ) {
        element
            .parent()
            .find(".switchery")
            .trigger("click");
    }
}

$(function () {
    $(".bs-switch").bootstrapSwitch();

    //Classic Switchery
    var elems = Array.prototype.slice.call(
        document.querySelectorAll(".f-switchery-input")
    );
    elems.forEach(function (html) {
        var switchery = new Switchery(html);
    });

    //Group Changer Switchery
    var groupelems = Array.prototype.slice.call(
        document.querySelectorAll(".f-switchery-all")
    );
    groupelems.forEach(function (el) {
        var groupswitchery = new Switchery(el);

        $(el).on("change", function () {
            var checked = $(this).is(":checked");
            $.each(
                $(this)
                    .closest(".parent")
                    .find(".childrencontainer")
                    .find("input.f-switchery-input"),
                function (i, elem) {
                    changeSwitchery($(elem), checked);
                }
            );
        });
    });

    $(".form-check-input-styled-primary").uniform({
        wrapperClass: "border-primary-600 text-primary-800"
    });

    // Danger
    $(".form-check-input-styled-danger").uniform({
        wrapperClass: "border-danger-600 text-danger-800"
    });

    // Success
    $(".form-check-input-styled-success").uniform({
        wrapperClass: "border-success-600 text-success-800"
    });

    // Warning
    $(".form-check-input-styled-warning").uniform({
        wrapperClass: "border-warning-600 text-warning-800"
    });

    // Info
    $(".form-check-input-styled-info").uniform({
        wrapperClass: "border-info-600 text-info-800"
    });

    // Custom color
    $(".form-check-input-styled-custom").uniform({
        wrapperClass: "border-indigo-600 text-indigo-800"
    });
});

//Maxlength

$(function () {
    $items = $(".maxlength");
    $.each($items, function (key, item) {
        $(item).maxlength({
            threshold: $(item).data("treshold")
        });
    });
});

//Passy
var passFeedback = [
    {color: "#D55757", text: "Zayıf", textColor: "#fff"},
    {color: "#EB7F5E", text: "Normal", textColor: "#fff"},
    {color: "#3BA4CE", text: "İyi", textColor: "#fff"},
    {color: "#40B381", text: "Güçlü", textColor: "#fff"}
];
$(function () {
    $passwordGroups = $(".f-group.password");
    $.each($passwordGroups, function (key, item) {
        $(item)
            .find("input")
            .passy(function (strength) {
                var $badge = $(item).find("span");
                $badge.text(passFeedback[strength].text);
                $badge.css({
                    "background-color": passFeedback[strength].color,
                    color: passFeedback[strength].textColor
                });
            });
    });
});

//Noty
$(function () {
    Noty.overrideDefaults({
        theme: "limitless",
        layout: "topRight",
        type: "alert",
        timeout: 2500
    });
});

//SELECT 2
$(function () {
    $(".f-group select.select2").select2({
        minimumResultsForSearch: Infinity
    });
});

//DATE PICKERS
$(function () {
    // 10 minute increments
    $(".daterange").daterangepicker({
        showDropdowns: true,
        timePicker: true,
        opens: "left",
        applyClass: "bg-slate-600",
        cancelClass: "btn-light",
        timePickerIncrement: 5,
        locale: {
            format: "dd/mm/YYYY HH:mm"
        }
    });

    $(".date").pickadate();

    $(".timepicker").AnyTime_picker({
        format: "%H:%i"
    });

    //
    $(".date-change-input").daterangepicker({
        "singleDatePicker": true,
        "showDropdowns": true,
        "timePicker": true,
        "timePicker24Hour": true,
        "dateFormat": "YYYY-MM-DD HH:mm:ss",
        "autoUpdateInput": false,

        "locale": {
            "format": "YYYY-MM-DD HH:mm:ss",
            "applyLabel": "Uygula",
            "cancelLabel": "Vazgeç",
            "weekLabel": "W",
            "daysOfWeek": [
                "Paz",
                "Pzt",
                "Sal",
                "Çar",
                "Per",
                "Cum",
                "Cmt"
            ],
            "monthNames": [
                "Ocak",
                "Şubat",
                "Mart",
                "Nisan",
                "Mayıs",
                "Haziran",
                "Temmuz",
                "Ağustos",
                "Eylül",
                "Ekim",
                "Kasım",
                "Aralık"
            ]
        }
    }, function (chosen_date) {
        $(this.element[0]).val(chosen_date.format('YYYY-MM-DD HH:mm:ss'));
    });

});

var App = (function () {
    //
    // Setup module components
    //

    // Transitions
    // -------------------------

    // Disable all transitions
    var _transitionsDisabled = function () {
        $("body").addClass("no-transitions");
    };

    // Enable all transitions
    var _transitionsEnabled = function () {
        $("body").removeClass("no-transitions");
    };

    // Sidebars
    // -------------------------

    //
    // On desktop
    //

    // Resize main sidebar
    var _sidebarMainResize = function () {
        // Flip 2nd level if menu overflows
        // bottom edge of browser window
        var revertBottomMenus = function () {
            $(".sidebar-main")
                .find(".nav-sidebar")
                .children(".nav-item-submenu")
                .hover(function () {
                    var totalHeight = 0,
                        $this = $(this),
                        navSubmenuClass = "nav-group-sub",
                        navSubmenuReversedClass = "nav-item-submenu-reversed";

                    totalHeight += $this
                        .find("." + navSubmenuClass)
                        .filter(":visible")
                        .outerHeight();
                    if ($this.children("." + navSubmenuClass).length) {
                        if (
                            $this.children("." + navSubmenuClass).offset().top +
                            $this
                                .find("." + navSubmenuClass)
                                .filter(":visible")
                                .outerHeight() >
                            document.body.clientHeight
                        ) {
                            $this.addClass(navSubmenuReversedClass);
                        } else {
                            $this.removeClass(navSubmenuReversedClass);
                        }
                    }
                });
        };

        // If sidebar is resized by default
        if ($("body").hasClass("sidebar-xs")) {
            revertBottomMenus();
        }

        // Toggle min sidebar class
        $(".sidebar-main-toggle").on("click", function (e) {
            e.preventDefault();

            $("body")
            //.toggleClass("sidebar-xs")
                .toggleClass("sidebar-mobile-main");
            //.removeClass("sidebar-mobile-main");
            revertBottomMenus();
        });
    };

    // Toggle main sidebar
    var _sidebarMainToggle = function () {
        $(document).on("click", ".sidebar-main-hide", function (e) {
            e.preventDefault();
            $("body").toggleClass("sidebar-main-hidden");
        });
    };

    // Toggle secondary sidebar
    var _sidebarSecondaryToggle = function () {
        $(document).on("click", ".sidebar-secondary-toggle", function (e) {
            e.preventDefault();
            $("body").toggleClass("sidebar-secondary-hidden");
        });
    };

    // Show right, resize main
    var _sidebarRightMainToggle = function () {
        $(document).on("click", ".sidebar-right-main-toggle", function (e) {
            e.preventDefault();

            // Right sidebar visibility
            $("body").toggleClass("sidebar-right-visible");

            // If visible
            if ($("body").hasClass("sidebar-right-visible")) {
                // Make main sidebar mini
                //$("body").addClass("sidebar-xs");

                // Hide children lists if they are opened, since sliding animation adds inline CSS
                $(".sidebar-main .nav-sidebar")
                    .children(".nav-item")
                    .children(".nav-group-sub")
                    .css("display", "");
            } else {
                $("body").removeClass("sidebar-xs");
            }
        });
    };

    // Show right, hide main
    var _sidebarRightMainHide = function () {
        $(document).on("click", ".sidebar-right-main-hide", function (e) {
            e.preventDefault();

            // Opposite sidebar visibility
            $("body").toggleClass("sidebar-right-visible");

            // If visible
            if ($("body").hasClass("sidebar-right-visible")) {
                $("body").addClass("sidebar-main-hidden");
            } else {
                $("body").removeClass("sidebar-main-hidden");
            }
        });
    };

    // Toggle right sidebar
    var _sidebarRightToggle = function () {
        $(document).on("click", ".sidebar-right-toggle", function (e) {
            e.preventDefault();

            $("body").toggleClass("sidebar-right-visible");
        });
    };

    // Show right, hide secondary
    var _sidebarRightSecondaryToggle = function () {
        $(document).on("click", ".sidebar-right-secondary-toggle", function (e) {
            e.preventDefault();

            // Opposite sidebar visibility
            $("body").toggleClass("sidebar-right-visible");

            // If visible
            if ($("body").hasClass("sidebar-right-visible")) {
                $("body").addClass("sidebar-secondary-hidden");
            } else {
                $("body").removeClass("sidebar-secondary-hidden");
            }
        });
    };

    // Toggle content sidebar
    var _sidebarComponentToggle = function () {
        $(document).on("click", ".sidebar-component-toggle", function (e) {
            e.preventDefault();
            $("body").toggleClass("sidebar-component-hidden");
        });
    };

    //
    // On mobile
    //

    // Expand sidebar to full screen on mobile
    var _sidebarMobileFullscreen = function () {
        $(".sidebar-mobile-expand").on("click", function (e) {
            e.preventDefault();
            var $sidebar = $(this).parents(".sidebar"),
                sidebarFullscreenClass = "sidebar-fullscreen";

            if (!$sidebar.hasClass(sidebarFullscreenClass)) {
                $sidebar.addClass(sidebarFullscreenClass);
            } else {
                $sidebar.removeClass(sidebarFullscreenClass);
            }
        });
    };

    // Toggle main sidebar on mobile
    var _sidebarMobileMainToggle = function () {
        $(".sidebar-mobile-main-toggle").on("click", function (e) {
            e.preventDefault();
            $("body")
                .toggleClass("sidebar-mobile-main")
                .removeClass("sidebar-mobile-secondary sidebar-mobile-right");

            if ($(".sidebar-main").hasClass("sidebar-fullscreen")) {
                $(".sidebar-main").removeClass("sidebar-fullscreen");
            }
        });
    };

    // Toggle secondary sidebar on mobile
    var _sidebarMobileSecondaryToggle = function () {
        $(".sidebar-mobile-secondary-toggle").on("click", function (e) {
            e.preventDefault();
            $("body")
                .toggleClass("sidebar-mobile-secondary")
                .removeClass("sidebar-mobile-main sidebar-mobile-right");

            // Fullscreen mode
            if ($(".sidebar-secondary").hasClass("sidebar-fullscreen")) {
                $(".sidebar-secondary").removeClass("sidebar-fullscreen");
            }
        });
    };

    // Toggle right sidebar on mobile
    var _sidebarMobileRightToggle = function () {
        $(".sidebar-mobile-right-toggle").on("click", function (e) {
            e.preventDefault();
            $("body")
                .toggleClass("sidebar-mobile-right")
                .removeClass("sidebar-mobile-main sidebar-mobile-secondary");

            // Hide sidebar if in fullscreen mode on mobile
            if ($(".sidebar-right").hasClass("sidebar-fullscreen")) {
                $(".sidebar-right").removeClass("sidebar-fullscreen");
            }
        });
    };

    // Toggle component sidebar on mobile
    var _sidebarMobileComponentToggle = function () {
        $(".sidebar-mobile-component-toggle").on("click", function (e) {
            e.preventDefault();
            $("body").toggleClass("sidebar-mobile-component");
        });
    };

    // Navigations
    // -------------------------

    // Sidebar navigation
    var _navigationSidebar = function () {
        // Define default class names and options
        var navClass = "nav-sidebar",
            navItemClass = "nav-item",
            navItemOpenClass = "nav-item-open",
            navLinkClass = "nav-link",
            navSubmenuClass = "nav-group-sub",
            navSlidingSpeed = 250;

        // Configure collapsible functionality
        $("." + navClass).each(function () {
            $(this)
                .find("." + navItemClass)
                .has("." + navSubmenuClass)
                .children("." + navItemClass + " > " + "." + navLinkClass)
                .not(".disabled")
                .on("click", function (e) {
                    e.preventDefault();

                    // Simplify stuff
                    var $target = $(this),
                        $navSidebarMini = $(".sidebar-xs")
                            .not(".sidebar-mobile-main")
                            .find(".sidebar-main ." + navClass)
                            .children("." + navItemClass);

                    // Collapsible
                    if ($target.parent("." + navItemClass).hasClass(navItemOpenClass)) {
                        $target
                            .parent("." + navItemClass)
                            .not($navSidebarMini)
                            .removeClass(navItemOpenClass)
                            .children("." + navSubmenuClass)
                            .slideUp(navSlidingSpeed);
                    } else {
                        $target
                            .parent("." + navItemClass)
                            .not($navSidebarMini)
                            .addClass(navItemOpenClass)
                            .children("." + navSubmenuClass)
                            .slideDown(navSlidingSpeed);
                    }

                    // Accordion
                    if ($target.parents("." + navClass).data("nav-type") == "accordion") {
                        $target
                            .parent("." + navItemClass)
                            .not($navSidebarMini)
                            .siblings(":has(." + navSubmenuClass + ")")
                            .removeClass(navItemOpenClass)
                            .children("." + navSubmenuClass)
                            .slideUp(navSlidingSpeed);
                    }
                });
        });

        // Disable click in disabled navigation items
        $(document).on("click", "." + navClass + " .disabled", function (e) {
            e.preventDefault();
        });

        // Scrollspy navigation
        $(".nav-scrollspy")
            .find("." + navItemClass)
            .has("." + navSubmenuClass)
            .children("." + navItemClass + " > " + "." + navLinkClass)
            .off("click");
    };

    // Navbar navigation
    var _navigationNavbar = function () {
        // Prevent dropdown from closing on click
        $(document).on("click", ".dropdown-content", function (e) {
            e.stopPropagation();
        });

        // Disabled links
        $(".navbar-nav .disabled a, .nav-item-levels .disabled").on(
            "click",
            function (e) {
                e.preventDefault();
                e.stopPropagation();
            }
        );

        // Show tabs inside dropdowns
        $(".dropdown-content a[data-toggle=\"tab\"]").on("click", function (e) {
            $(this).tab("show");
        });
    };

    // Components
    // -------------------------

    // Tooltip
    var _componentTooltip = function () {
        // Initialize
        $("[data-popup=\"tooltip\"]").tooltip();

        // Demo tooltips, remove in production
        var demoTooltipSelector = "[data-popup=\"tooltip-demo\"]";
        if ($(demoTooltipSelector).is(":visible")) {
            $(demoTooltipSelector).tooltip("show");
            setTimeout(function () {
                $(demoTooltipSelector).tooltip("hide");
            }, 2000);
        }
    };

    // Popover
    var _componentPopover = function () {
        $("[data-popup=\"popover\"]").popover();
    };

    // Card actions
    // -------------------------

    // Reload card (uses BlockUI extension)
    var _cardActionReload = function () {
        $(".card [data-action=reload]:not(.disabled)").on("click", function (e) {
            e.preventDefault();
            var $target = $(this),
                block = $target.closest(".card");

            // Block card
            $(block).block({
                message: "<i class=\"icon-spinner2 spinner\"></i>",
                overlayCSS: {
                    backgroundColor: "#fff",
                    opacity: 0.8,
                    cursor: "wait",
                    "box-shadow": "0 0 0 1px #ddd"
                },
                css: {
                    border: 0,
                    padding: 0,
                    backgroundColor: "none"
                }
            });

            // For demo purposes
            window.setTimeout(function () {
                $(block).unblock();
            }, 2000);
        });
    };

    // Collapse card
    var _cardActionCollapse = function () {
        var $cardCollapsedClass = $(".card-collapsed");

        // Hide if collapsed by default
        $cardCollapsedClass
            .children(".card-header")
            .nextAll()
            .hide();

        // Rotate icon if collapsed by default
        $cardCollapsedClass.find("[data-action=collapse]").addClass("rotate-180");

        // Collapse on click
        $(".card [data-action=collapse]:not(.disabled)").on("click", function (e) {
            var $target = $(this),
                slidingSpeed = 150;

            e.preventDefault();
            $target.parents(".card").toggleClass("card-collapsed");
            $target.toggleClass("rotate-180");
            $target
                .closest(".card")
                .children(".card-header")
                .nextAll()
                .slideToggle(slidingSpeed);
        });
    };

    // Remove card
    var _cardActionRemove = function () {
        $(".card [data-action=remove]").on("click", function (e) {
            e.preventDefault();
            var $target = $(this),
                slidingSpeed = 150;

            // If not disabled
            if (!$target.hasClass("disabled")) {
                $target.closest(".card").slideUp({
                    duration: slidingSpeed,
                    start: function () {
                        $target.addClass("d-block");
                    },
                    complete: function () {
                        $target.remove();
                    }
                });
            }
        });
    };

    // Card fullscreen mode
    var _cardActionFullscreen = function () {
        $(".card [data-action=fullscreen]").on("click", function (e) {
            e.preventDefault();

            // Define vars
            var $target = $(this),
                cardFullscreen = $target.closest(".card"),
                overflowHiddenClass = "overflow-hidden",
                collapsedClass = "collapsed-in-fullscreen",
                fullscreenAttr = "data-fullscreen";

            // Toggle classes on card
            cardFullscreen.toggleClass("fixed-top h-100 rounded-0");

            // Configure
            if (!cardFullscreen.hasClass("fixed-top")) {
                $target.removeAttr(fullscreenAttr);
                cardFullscreen.children("." + collapsedClass).removeClass("show");
                $("body").removeClass(overflowHiddenClass);
                $target
                    .siblings(
                        "[data-action=move], [data-action=remove], [data-action=collapse]"
                    )
                    .removeClass("d-none");
            } else {
                $target.attr(fullscreenAttr, "active");
                cardFullscreen
                    .removeAttr("style")
                    .children(".collapse:not(.show)")
                    .addClass("show " + collapsedClass);
                $("body").addClass(overflowHiddenClass);
                $target
                    .siblings(
                        "[data-action=move], [data-action=remove], [data-action=collapse]"
                    )
                    .addClass("d-none");
            }
        });
    };

    // Misc
    // -------------------------

    // Dropdown submenus. Trigger on click
    var _dropdownSubmenu = function () {
        // All parent levels require .dropdown-toggle class
        $(".dropdown-menu")
            .find(".dropdown-submenu")
            .not(".disabled")
            .find(".dropdown-toggle")
            .on("click", function (e) {
                e.stopPropagation();
                e.preventDefault();

                // Remove "show" class in all siblings
                $(this)
                    .parent()
                    .siblings()
                    .removeClass("show")
                    .find(".show")
                    .removeClass("show");

                // Toggle submenu
                $(this)
                    .parent()
                    .toggleClass("show")
                    .children(".dropdown-menu")
                    .toggleClass("show");

                // Hide all levels when parent dropdown is closed
                $(this)
                    .parents(".show")
                    .on("hidden.bs.dropdown", function (e) {
                        $(".dropdown-submenu .show, .dropdown-submenu.show").removeClass(
                            "show"
                        );
                    });
            });
    };

    // Header elements toggler
    var _headerElements = function () {
        // Toggle visible state of header elements
        $(".header-elements-toggle").on("click", function (e) {
            e.preventDefault();
            $(this)
                .parents("[class*=header-elements-]")
                .find(".header-elements")
                .toggleClass("d-none");
        });

        // Toggle visible state of footer elements
        $(".footer-elements-toggle").on("click", function (e) {
            e.preventDefault();
            $(this)
                .parents(".card-footer")
                .find(".footer-elements")
                .toggleClass("d-none");
        });
    };

    //
    // Return objects assigned to module
    //

    return {
        // Disable transitions before page is fully loaded
        initBeforeLoad: function () {
            _transitionsDisabled();
        },

        // Enable transitions when page is fully loaded
        initAfterLoad: function () {
            _transitionsEnabled();
        },

        // Initialize all sidebars
        initSidebars: function () {
            // On desktop
            _sidebarMainResize();
            _sidebarMainToggle();
            _sidebarSecondaryToggle();
            _sidebarRightMainToggle();
            _sidebarRightMainHide();
            _sidebarRightToggle();
            _sidebarRightSecondaryToggle();
            _sidebarComponentToggle();

            // On mobile
            _sidebarMobileFullscreen();
            _sidebarMobileMainToggle();
            _sidebarMobileSecondaryToggle();
            _sidebarMobileRightToggle();
            _sidebarMobileComponentToggle();
        },

        // Initialize all navigations
        initNavigations: function () {
            _navigationSidebar();
            _navigationNavbar();
        },

        // Initialize all components
        initComponents: function () {
            _componentTooltip();
            _componentPopover();
        },

        // Initialize all card actions
        initCardActions: function () {
            _cardActionReload();
            _cardActionCollapse();
            _cardActionRemove();
            _cardActionFullscreen();
        },

        // Dropdown submenu
        initDropdownSubmenu: function () {
            _dropdownSubmenu();
        },

        initHeaderElementsToggle: function () {
            _headerElements();
        },

        // Initialize core
        initCore: function () {
            App.initSidebars();
            App.initNavigations();
            App.initComponents();
            App.initCardActions();
            App.initDropdownSubmenu();
            App.initHeaderElementsToggle();
        }
    };
})();


/*
* nice scroll
* */
miniSidebar = () => {
    if ($('body').hasClass('sidebar-xs')) {
        $('.sidebar-main.sidebar-fixed .sidebar-content').on('mouseenter', () => {
            if ($('body').hasClass('sidebar-xs')) {
                $('body').removeClass('sidebar-xs').addClass('sidebar-fixed-expanded');
            }
        }).on('mouseleave', () => {
            if ($('body').hasClass('sidebar-fixed-expanded')) {
                $('body').removeClass('sidebar-fixed-expanded').addClass('sidebar-xs');
            }
        });
    }
};

initScroll = () => {
    $(".sidebar-fixed .sidebar-content").niceScroll({
        mousescrollstep: 100,
        cursorcolor: '#ccc',
        cursorborder: '',
        cursorwidth: 3,
        hidecursordelay: 100,
        autohidemode: 'scroll',
        horizrailenabled: false,
        preservenativescrolling: false,
        railpadding: {
            right: 0.5,
            top: 1.5,
            bottom: 1.5
        }
    });
};

removeScroll = () => {
    $(".sidebar-fixed .sidebar-content").getNiceScroll().remove();
    $(".sidebar-fixed .sidebar-content").removeAttr('style').removeAttr('tabindex');
}

$(function () {
    miniSidebar();
    $('.sidebar-main-toggle').on('click', (e) => {
        miniSidebar();
    });
    initScroll();

    $(window).on('resize', () => {
        setTimeout(() => {
            if ($(window).width() <= 768) {
                removeScroll();
            } else {
                initScroll();
            }
        }, 100);
    }).resize();
});