<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Migrations\Migration;
use Nette\Multilingual\Database\Schema\ExtendedBlueprint;

class AddSlugColumnToWidgetPackage extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $schema = \DB::connection()->getSchemaBuilder();

        // replace blueprint
        $schema->blueprintResolver(function ($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });

        $schema->table('widgets', function (ExtendedBlueprint $table) {
            $table->multiLangString('slug', true);
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('widgets', function (ExtendedBlueprint $table) {
            $table->dropColumn('slug');
        });
    }
}
