<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Migrations\Migration;
use Nette\Multilingual\Database\Schema\ExtendedBlueprint;

class AddStyleColumnToCategoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $schema = \DB::connection()->getSchemaBuilder();

        // replace blueprint
        $schema->blueprintResolver(function ($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });

        $schema->table('categories', function (ExtendedBlueprint $table) {
            $table->string('style')->nullable();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('categories', function (ExtendedBlueprint $table) {
            $table->dropColumn('style');
        });
    }
}
