<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Migrations\Migration;
use Nette\Multilingual\Database\Schema\ExtendedBlueprint;

class AddVideoIdColumnToSliderPackage extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $schema = \DB::connection()->getSchemaBuilder();

        // replace blueprint
        $schema->blueprintResolver(function ($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });

        $schema->table('sliders', function (ExtendedBlueprint $table) {
            $table->bigInteger("video_id_tr")->nullable();
            $table->bigInteger("video_id_en")->nullable();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('sliders', function (ExtendedBlueprint $table) {
            $table->dropColumn('video_id_tr');
            $table->dropColumn('video_id_en');
        });
    }
}
