<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Nette\Multilingual\Database\Schema\ExtendedBlueprint;

class CreateCitiesPackage extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $schema = \DB::connection()->getSchemaBuilder();

        // replace blueprint
        $schema->blueprintResolver(function ($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });

        $schema->create('cities', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->multiLangString('name', true);
            $table->multiLangText('body', true);
            $table->integer('order_number')->default(0);
            $table->integer('author')->nullable();
            $table->integer('edit_author')->nullable();
            $table->enum('publish_status', [1, 0])->default(1);
            $table->boolean('lock')->default(false);
            $table->boolean('status')->default(false);
            $table->text('meta')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('cities');
    }
}
