<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Nette\Multilingual\Database\Schema\ExtendedBlueprint;

class CreateProductPackage extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $schema = \DB::connection()->getSchemaBuilder();

        // replace blueprint
        $schema->blueprintResolver(function ($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });


        $schema->create('products', function (ExtendedBlueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->multiLangString('name', false);
            $table->multiLangString('slug', true);

            $table->bigInteger('cover_id')->nullable();

            $table->multiLangText('spot', true);
            $table->multiLangString('youtube_link', true);
            $table->multiLangText('content', true);

            $table->integer('category_id')->unsigned();

            $table->bigInteger('mini_png1')->nullable();
            $table->bigInteger('mini_png2')->nullable();
            $table->bigInteger('detail_png1')->nullable();
            $table->bigInteger('detail_png2')->nullable();

            $table->string("color_style")->nullable();
            $table->boolean('showroom')->default(false);
            $table->integer('order_number')->default(0);
            $table->integer('author')->nullable();
            $table->integer('edit_author')->nullable();
            $table->enum('publish_status', [1, 0])->default(1);
            $table->boolean('status')->default(true);
            $table->boolean('home_page_view')->default(false);
            $table->boolean('lock')->default(false);
            $table->timestamp('date')->nullable();
            $table->text('meta')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        $schema->create('product_gallery', function (ExtendedBlueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->longText('title')->nullable();
            $table->longText('caption')->nullable();
            $table->text('source')->nullable();
            $table->integer('order')->default(0);
            $table->integer('product_id')->unsigned();
            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade')->onUpdate('cascade');
            $table->bigInteger('media_id')->unsigned();
            $table->foreign('media_id')->references('id')->on('media')->onDelete('cascade')->onUpdate('cascade');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_gallery');
        Schema::dropIfExists('products');
    }
}
