<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Nette\Multilingual\Database\Schema\ExtendedBlueprint;

class CreateProductFeaturePackage extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $schema = \DB::connection()->getSchemaBuilder();

        // replace blueprint
        $schema->blueprintResolver(function ($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });


        $schema->create('product_features', function (ExtendedBlueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->multiLangString('name', true);
            $table->bigInteger('photo_id')->nullable();
            $table->integer('product_id')->unsigned();
            $table->integer('order_number')->default(0)->nullable();
            $table->integer('author')->nullable();
            $table->integer('edit_author')->nullable();
            $table->enum('publish_status', [1, 0])->default(1);
            $table->boolean('status')->default(true);
            $table->boolean('lock')->default(false);
            $table->timestamps();
            $table->softDeletes();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_features');
    }
}
