<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Nette\Multilingual\Database\Schema\ExtendedBlueprint;

class CreateArticleCatPackage extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $schema = \DB::connection()->getSchemaBuilder();

        // replace blueprint
        $schema->blueprintResolver(function ($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });

        $schema->create('article_cats', function (ExtendedBlueprint $table) {
            $table->increments('id');
            $table->multiLangString('name', false);
            $table->multiLangString('slug', true);
            $table->multiLangText('content', true);
            $table->bigInteger('cover_id')->nullable();
            $table->bigInteger('banner_id')->nullable();
            $table->bigInteger('mini_png1')->nullable();
            $table->bigInteger('mini_png2')->nullable();
            $table->multiLangText('short_content', true);
            $table->multiLangText('long_content', true);
            $table->boolean('home_showroom')->default(false);

            $table->integer('author')->nullable();
            $table->integer('edit_author')->nullable();
            $table->bigInteger('photo_id')->nullable();
            $table->integer('order_number')->default(0);
            $table->integer('parent_id')->default(0)->nullable();
            $table->enum('publish_status', [1, 0])->default(1);
            $table->boolean('lock')->default(false);
            $table->boolean('status')->default(false);
            $table->boolean('home_page_view')->default(false);
            $table->timestamp('date')->nullable();
            $table->text('meta')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('article_cats');
    }
}
