<?php

use Illuminate\Support\Facades\Schema;
use Nette\Multilingual\Database\Schema\ExtendedBlueprint;
use Illuminate\Database\Migrations\Migration;

class CreateArticlesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $schema = \DB::connection()->getSchemaBuilder();

        // replace blueprint
        $schema->blueprintResolver(function ($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });

        $schema->create('articles', function (ExtendedBlueprint $table) {
            $table->bigIncrements('id');
            $table->multiLangString('name', false);
            $table->multiLangString('slug', true);
            $table->multiLangText('content', true);
            $table->integer('order_number')->default(0);
            $table->integer('number_of_reads')->default(0)->nullable();
            $table->bigInteger('photo_id')->nullable();
            $table->bigInteger('cover_id')->nullable();
            $table->text('meta')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
            $table->softDeletes();
        });

        $schema->create('article_galleries', function (ExtendedBlueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->longText('title')->nullable();
            $table->longText('caption')->nullable();
            $table->text('source')->nullable();
            $table->integer('order')->default(0);

            // article_id sütununu unsignedBigInteger olarak güncelle
            $table->unsignedBigInteger('article_id');
            $table->foreign('article_id')->references('id')->on('articles')->onDelete('cascade')->onUpdate('cascade');

            // media_id sütununu unsignedBigInteger olarak güncelle
            $table->unsignedBigInteger('media_id');
            $table->foreign('media_id')->references('id')->on('media')->onDelete('cascade')->onUpdate('cascade');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('articles');
        Schema::dropIfExists('article_galleries');
    }
}
