<?php
if (!function_exists('getAdmin')) {
    function getAdmin($id)
    {
        $admin = \Nette\Admin\Models\Admin::withTrashed()->find($id);
        return $admin ? $admin->name : 'Tanımsız';
    }
}

if (!function_exists('frontUrl')) {
    function frontUrl($object)
    {
        //dd($object);
        if ($object) {
            return html()->a(
                $object['url'],
                $object['name'])->attribute('target', 'blank');
        }
        return '';
    }
}

if (!function_exists('globalDate')) {
    function globalDate($date)
    {
        return $date->format('d-m-Y H:i');
    }
}


if (!function_exists('shortUrlBtn')) {
    function shortUrlBtn($object)
    {
        if ($object) {
            $shorturl = html()->a(
                'javascript:void(0)',
                html()->i()->class('icon-link2')
            )
                ->class('btn btn-icon bg-slate-700 urlshorten-btn')
                ->addClass('legitRipple')
                ->data('url', $object['url'])
                ->data('target', route('admin.common.urlshorten'));

             $copyurl = html()->a(
                 'javascript:void(0)',
                 html()->i()->class('icon-copy2')
             )
                 ->class('btn btn-icon bg-orange-300 urlcopy-btn')
                 ->addClass('legitRipple')
                 ->data('clipboard-text', $object['url']);

             return $shorturl. ' ' . $copyurl;
        }
        return '';
    }
}

if (!function_exists('classTypes')) {
    function classTypes($className)
    {
        $result = [];
        $reflector = new ReflectionClass($className);
        $constants = $reflector->getConstants();
        foreach ($constants as $key => $val) {
            $str = $reflector->getReflectionConstant($key)->getDocComment();
            $result[$val] = trim(rtrim(ltrim($str, '/**'), '/*'));
        }
        return ($result);
    }
}

if (!function_exists('publicationName')) {
    function publicationName($id)
    {
        $publicationData = classTypes(\App\Packages\_Common\Types\PublicationTypes::class);
        return $publicationData[$id] ?? 'Tanımsız';
    }
}

if (!function_exists('redirectCheck')) {
    function redirectCheck($redirection)
    {
        if ($redirection == 1) {
            $icon = '<i class="icon-checkmark position-center icon-red" data-popup="tooltip" title="Evet" data-placement="right"></i>';
        } else {
            $icon = '<i class="icon-cross2 position-center icon-green" data-popup="tooltip" title="Hayır" data-placement="right"></i>';
        }

        return $icon;
    }
}
