@extends('admin::_layouts.content',['selectedMenu'=>$cMenuKey])
@section('content')
    @layoutmodule('up')
    <div class="page-header">
        <div class="page-header-content header-elements-md-inline">
            <div class="page-title d-flex">
                <h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold"> {{ $cTitle }}</span> -
                    {{ $cIndexTitle }}</h4>
                <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
            </div>

            <div class="header-elements d-none text-center text-md-left mb-3 mb-md-0">
                @if($cCreate)
                    @check($cCreatePermission)
                    {!! createbtn($cCreateRoute) !!}
                    @endcheck
                @endif
            </div>
        </div>
    </div>
    <div class="content pt-0 ">
        @layoutmodule('up-content')
        <div class="card">
            <div class="card-header header-elements-inline">
                <h5 class="card-title">{{ $cIndexTitle }}</h5>

                @layoutmodule('table-header')
                @if($cFilterable)
                    {!! FilterGenerator::button() !!}
                @endif
            </div>

            @if($cFilterable)
                {!! FilterGenerator::render() !!}
            @endif

            @if($cOrderable)
                @check($cEditPermission)
                {!! html()->form('POST',route($cOrderableRoute))->open() !!}
                @endcheck
            @endif
            <div class="index-table">
                <div class="table-responsive table-bordered table-striped">
                    <table class="table @if($cSortable) sortable-table @endif">
                        <thead>
                        <tr>
                            @if($cSortable)
                                @check($cEditPermission)
                                <th class="table-column-sort"></th>
                                @endcheck
                            @endif

                            @if($cBatchDelete)
                                @check($cDeletePermission)
                                <th class="table-column-select">
                                    <div class="form-check">
                                        {!! html()->checkbox('select-all')->class('form-check-input')->addClass('position-static')->addClass('select-all-list')->checked('') !!}
                                    </div>
                                </th>
                                @endcheck
                            @endif
                            @if($cOrderable)
                                @check($cEditPermission)
                                <th class="table-column-mini">Sıra</th>
                                @endcheck
                            @endif
                            @foreach(($cFields ?? []) as $fieldKey => $fieldData)
                                @if((!isset($fieldData['permission'])) || (isset($fieldData['permission']) && checkPermission($fieldData['permission'])))
                                    @if(config('nette-lang.enable') && ($fieldData['multilang'] ?? false))

                                        @foreach(adminlangs() as $langKey => $lang)
                                            <th class="

                                          @if($fieldData['size'] ?? false) table-column-{{$fieldData['size']}} @endif

                                                ">

                                                {{$fieldData['name'] . '('.$lang.')'}}
                                                @if($fieldData['sortable'] ?? false)
                                                    {!! _sorting($fieldKey) !!}
                                                @endif
                                            </th>
                                        @endforeach

                                    @else
                                        <th class="@if($fieldData['size'] ?? false) table-column-{{$fieldData['size']}} @endif">
                                            {{$fieldData['name']}}
                                            @if($fieldData['sortable'] ?? false)
                                                {!! _sorting($fieldKey) !!}
                                            @endif

                                        </th>
                                    @endif
                                @endif
                            @endforeach
                            @if($cIndexActions)
                                <th class="table-column-actions">İşlemler</th>
                            @endif
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($items as $item)
                            <tr>

                                @if($cSortable)
                                    @check($cEditPermission)
                                    <td class="table-column-sort">
                                        <i class="icon-arrow-resize8"></i>
                                    </td>
                                    @endcheck
                                @endif


                                @if($cBatchDelete)
                                    @check($cDeletePermission)
                                    <td class="table-column-select">
                                        @if(!$item->lock)
                                            <div class="form-check">
                                                {!! html()->checkbox('selection')
                                                ->class('form-check-input')
                                                ->addClass('position-static')
                                                ->addClass('selection')
                                                ->data('id',$item->id) !!}
                                            </div>
                                        @endif
                                    </td>
                                    @endcheck
                                @endif


                                @if($cOrderable)
                                    @check($cEditPermission)
                                    <td class="table-column-mini">
                                        {{ html()->text('order_number['.$item->id.']')->class('form-control')->value(($item->$cOrderableColumn) ?? 0) }}
                                    </td>
                                    @endcheck
                                @endif

                                @foreach(($cFields ?? []) as $fieldKey=>$fieldData)
                                    @if(config('nette-lang.enable') && ($fieldData['multilang'] ?? false))
                                        @foreach(adminlangs() as $langKey => $lang)
                                            <td class="nowrap">{{ $item->{localizedAttributeName($fieldKey,$langKey)} }}</td>
                                        @endforeach
                                    @else
                                        @if((!isset($fieldData['permission'])) || (isset($fieldData['permission']) && checkPermission($fieldData['permission'])))
                                            <td class="@if($fieldData['size'] ?? false) table-column-{{$fieldData['size']}} @endif">
                                                @if(isset($cFieldMutators[$fieldKey]))
                                                    @if(is_array($cFieldMutators[$fieldKey]))

                                                        @if(isset($cFieldMutators[$fieldKey]['method']) && isset($cFieldMutators[$fieldKey]['parameter']))
                                                            @if($cFieldMutators[$fieldKey]['parameter'] == 'object')
                                                                {!! ($cFieldMutators[$fieldKey]['method'])($item ?? '') !!}
                                                            @else
                                                                {!! $cFieldMutators[$fieldKey](($cFieldMutators[$fieldKey]['parameter']) ?? '') !!}
                                                            @endif
                                                        @else
                                                            {!! $cFieldMutators[$fieldKey](($item->$fieldKey) ?? '') !!}
                                                        @endif

                                                    @else
                                                        {!! $cFieldMutators[$fieldKey](($item->$fieldKey) ?? '') !!}
                                                    @endif
                                                @else
                                                    {{($item->$fieldKey) ?? ''}}
                                                @endif
                                            </td>
                                        @endif
                                    @endif
                                @endforeach

                                @if($cIndexActions)
                                    <td class="table-column-actions">
                                        @if($cShow)
                                            {!! showbtn($cShowRoute,['id'=>$item->id]) !!}
                                        @endif
                                        @if($cEdit)
                                            @check($cEditPermission)
                                            {!! editbtn($cEditRoute,['id'=>$item->id]) !!}
                                            @endcheck
                                        @endif
                                        @if($cPublish)
                                            @check($cPublishPermission)
                                            {!! publishbtn($cPublishRoute,['id'=>$item->id],$item->status) !!}
                                            @endcheck
                                        @endif
                                        @if($cDelete)
                                            @check($cDeletePermission)
                                            @if(!$item->lock)
                                                {!! deletebtn($cDeleteRoute,['id'=>$item->id]) !!}
                                            @endif
                                            @endcheck
                                        @endif
                                        {{--<a class="options-btn" data-toggle="dropdown" data-boundary="window"><i class="icon-arrow-down15 "></i></a>--}}
                                        {{--<div class="dropdown-menu dropdown-menu-right">--}}
                                        {{--<a href="#" class="dropdown-item"><i class="icon-menu7"></i>Aksiyon 1</a>--}}
                                        {{--<a href="#" class="dropdown-item"><i class="icon-screen-full"></i> Aksiyon 2</a>--}}
                                        {{--<a href="#" class="dropdown-item"><i class="icon-mail5"></i> Aksiyon 3</a>--}}
                                        {{--<div class="dropdown-divider"></div>--}}
                                        {{--<a href="#" class="dropdown-item"><i class="icon-gear"></i> Aksiyon 4</a>--}}
                                        {{--</div>--}}
                                    </td>
                                @endif
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
                <div class="table-bottom">
                    <div class="table-batch-actions">
                        <div class="wrap">
                            @if($cBatchDelete)
                                @check($cDeletePermission)
                                {!! batchdeletebtn($cBatchDeleteRoute) !!}
                                @endcheck
                            @endif

                            @if($cOrderable)
                                @check($cEditPermission)
                                {!! batchorderbtn() !!}
                                @endcheck
                            @endif

                        </div>
                    </div>
                    @if($items instanceof \Illuminate\Pagination\LengthAwarePaginator )
                        <div class="table-pagination">
                            {!! pagination($items) !!}
                        </div>
                    @endif
                </div>

                @layoutmodule('table-footer')
            </div>
            @if($cOrderable)
                @check($cEditPermission)
                {!! html()->form()->close() !!}
                @endcheck
            @endif
        </div>

        @layoutmodule('bottomcontent')

    </div>

    @layoutmodule('bottom')

@endsection
