<?php

Route::group(['prefix' => 'widget', 'as' => 'widget.'], function () {
    Route::get('/',                                 ['as' => 'index',   'uses' => 'App\Packages\Widget\WidgetController@index']);
    Route::get('/create',                           ['as' => 'create',  'uses' => 'App\Packages\Widget\WidgetController@create']);
    Route::post('/',                                ['as' => 'store',   'uses' => 'App\Packages\Widget\WidgetController@store']);
    Route::get('/{id}/edit',                        ['as' => 'edit',   'uses' => 'App\Packages\Widget\WidgetController@edit']);
    Route::match(['put', 'patch'], '/{id}/update',  ['as' => 'update',  'uses' => 'App\Packages\Widget\WidgetController@update']);
    Route::post('/{id}/publish',                    ['as' => 'publish',   'uses' => 'App\Packages\Widget\WidgetController@publish']);
    Route::delete('/{id}',                          ['as' => 'destroy', 'uses' => 'App\Packages\Widget\WidgetController@destroy']);
    Route::post('/batchdestroy',                    ['as' => 'batchdestroy', 'uses' => 'App\Packages\Widget\WidgetController@batchDestroy']);
    Route::post('/orderable',                       ['as' => 'orderable', 'uses' => 'App\Packages\Widget\WidgetController@orderable']);
    Route::get('/{id}',                             ['as' => 'show',    'uses' => 'App\Packages\Widget\WidgetController@show']);
    Route::post('/{id}/ordermedia',                 ['as' => 'ordermedia',   'uses' => 'App\Packages\Widget\WidgetController@orderMedia']);
    Route::post('/{id}/updatemedia',                ['as' => 'updatemedia',   'uses' => 'App\Packages\Widget\WidgetController@updateMedia']);
    Route::post('/{id}/deletemedia',                ['as' => 'deletemedia',   'uses' => 'App\Packages\Widget\WidgetController@deleteMedia']);
});
