<?php

namespace App\Packages\Widget;

use App\Packages\Slider\Requests\SliderRequest;
use App\Packages\Slider\Models\Slider;
use App\Packages\Widget\Models\Widget;
use App\Packages\Widget\Requests\WidgetRequest;
use Carbon\Carbon;
use Nette\Admin\Models\Page;
use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController as BaseController;
use FilterGenerator;

class WidgetController extends BaseController
{
    public $cTitle = 'Widgetlar';

    public $cMenuKey = 'widget';
    public $cModel = Widget::class;
    public $cModelName = 'Widget';

    public $cKey = 'widget';

    public $cIndexBlade = "Widget::index";
    public $cIndexRoute = 'admin.widget.index';
    public $cIndexTitle = 'Liste';
    public $cIndexPermission = 'widget.view';

    //region Create Settings
    public $cCreate = true;
    public $cCreateRoute = 'admin.widget.create';
    public $cCreateTitle = 'Yeni';
    public $cCreateMethodRoute = 'admin.widget.store';
    public $cCreatePermission = 'widget.create';
    public $cCreateBlade = 'Widget::create';
    //endregion


    //region Edit Settings
    public $cEdit = true;
    public $cEditRoute = 'admin.widget.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.widget.update';
    public $cEditPermission = 'widget.edit';
    //endregion

    //region Publish Settings
    public $cPublish = true;
    public $cPublishRoute = 'admin.widget.publish';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'widget.publish';
    //endregion

    public $cOrderable = true;
    public $cOrderableColumn = 'order_number';
    public $cOrderableRoute = 'admin.widget.orderable';

    //region Delete Settings
    public $cDelete = true;
    public $cDeleteRoute = 'admin.widget.destroy';
    public $cDeleteTitle = 'Sil';
    public $cDeletePermission = 'widget.delete';
    //endregion

    public $cOrderMediaRoute = 'admin.widget.ordermedia';
    public $cUpdateMediaRoute = 'admin.widget.updatemedia';
    public $cDeleteMediaRoute = 'admin.widget.deletemedia';

    public $cFields = [
        'id'       => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name_tr'  => ['name' => 'Widget Adı'],
        'photo_id' => ['name' => 'Widget İkonu'],
//        'category_id' => ['name' => 'Kategori', 'size' => 'small'],
//        'created_at'  => ['name' => 'Tarih', 'size' => 'medium'],
    ];

    public $cFieldMutators = [
        'created_at' => 'globalDate',
        'photo_id' => ['method' => 'photoIcon', 'parameter' => 'object'],
        //'name' => ['method' => 'frontUrl', 'parameter' => 'object']
    ];

    public $cSidebarModules = [
        'Widget::_partials.status',
//        '_Common::info',
    ];

//    public $cLayoutModules = [
//        'table-header' => [
//            'slider::_partials.video-get'
//        ],
//    ];

//    public $cJSModules = [
//
//        'slider::_partials.video-get-js'
//
//    ];

    public $cModuleFiles = [
        [
            'name'         => 'Widget resmi',
            'type'         => 'img',
            'key'          => 'widget',
            'database_key' => 'photo_id',
            'multiple'     => false,
            'attach_func'  => 'photo',
        ],/*
        [
            'name'        => 'Materyal Galerisi',
            'type'        => 'img',
            'key'         => 'widget_gallery',
            'multiple'    => true,
            'attach_func' => 'images',
        ],*/
    ];

    public $cFilterable = false;


    public function __construct()
    {
        parent::__construct();
    }


    public function store(WidgetRequest $request)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        $data                  = parent::_store($request, true);

        if ($data) {
            $request->session()->flash('success', 'Kayıt İşlemi Başarılı!');
        }

        return redirect()->route($this->cIndexRoute);
    }

    public function update(WidgetRequest $request, $id)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();

        return parent::_update($request, $id);
    }

}
