<?php

namespace App\Packages\Slider;

use App\Packages\Slider\Requests\SliderRequest;
use App\Packages\Slider\Models\Slider;
use Carbon\Carbon;
use Nette\Admin\Models\Page;
use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController as BaseController;
use FilterGenerator;

class SliderController extends BaseController
{
    public $cTitle = 'Sliderlar';

    public $cMenuKey = 'slider';
    public $cModel = Slider::class;
    public $cModelName = 'Slider';

    public $cKey = 'slider';

    public $cIndexBlade = null;
    public $cIndexRoute = 'admin.slider.index';
    public $cIndexTitle = 'Liste';
    public $cIndexPermission = 'slider.view';

    //region Create Settings
    public $cCreate = true;
    public $cCreateRoute = 'admin.slider.create';
    public $cCreateTitle = 'Yeni';
    public $cCreateMethodRoute = 'admin.slider.store';
    public $cCreatePermission = 'slider.create';
    public $cCreateBlade = 'Slider::create';
    //endregion


    //region Edit Settings
    public $cEdit = true;
    public $cEditRoute = 'admin.slider.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.slider.update';
    public $cEditPermission = 'slider.edit';
    //endregion

    //region Publish Settings
    public $cPublish = true;
    public $cPublishRoute = 'admin.slider.publish';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'slider.publish';
    //endregion

    public $cOrderable = true;
    public $cOrderableColumn = 'order_number';
    public $cOrderableRoute = 'admin.slider.orderable';

    //region Delete Settings
    public $cDelete = true;
    public $cDeleteRoute = 'admin.slider.destroy';
    public $cDeleteTitle = 'Sil';
    public $cDeletePermission = 'slider.delete';
    //endregion

    public $cFields = [
        'id'           => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name_tr'      => ['name' => 'Slider Adı'],
        'video_status' => ['name' => 'Slider Tipi'],
//        'location_type' => ['name' => 'Slider Lokasyonu'],
        'created_at'   => ['name' => 'Tarih', 'size' => 'medium'],
    ];

    public $cFieldMutators = [
        'created_at'   => 'globalDate',
        'video_status' => ['method' => 'sliderType', 'parameter' => 'object'],
//        'location_type' => ['method' => 'sliderLocation', 'parameter' => 'object'],
        //'name' => ['method' => 'frontUrl', 'parameter' => 'object']
    ];

    public $cSidebarModules = [
        'Slider::_partials.status',
        '_Common::info',
    ];

//    public $cLayoutModules = [
//        'table-header' => [
//            'slider::_partials.video-get'
//        ],
//    ];

//    public $cJSModules = [
//
//        'slider::_partials.video-get-js'
//
//    ];

    public $cModuleFiles = [
        [
            'name'         => 'Slider resmi (Turkce)',
            'type'         => 'img',
            'key'          => 'slider_tr',
            'database_key' => 'photo_id_tr',
            'multiple'     => false,
            'attach_func'  => 'phototr',
        ],
        [
            'name'         => 'Slider resmi (Ingilizce)',
            'type'         => 'img',
            'key'          => 'slider_en',
            'database_key' => 'photo_id_en',
            'multiple'     => false,
            'attach_func'  => 'photoen',
        ],
        [
            "name"         => "slider videosu (Turkce)",
            "type"         => "doc",
            "key"          => "mp4_key_tr",
            "database_key" => "video_id_tr",
            "multiple"     => false,
            "attach_func"  => "mp4tr",
        ],
        [
            "name"         => "slider videosu (Ingilizce)",
            "type"         => "doc",
            "key"          => "mp4_key_en",
            "database_key" => "video_id_en",
            "multiple"     => false,
            "attach_func"  => "mp4en",
        ],
    ];

    public $cFilterable = false;


    public function __construct()
    {
        parent::__construct();
    }


    public function store(SliderRequest $request)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        $request['page_key']   = "homepage";
        $data                  = parent::_store($request, true);

        if ($data) {
            $request->session()->flash('success', 'Kayıt İşlemi Başarılı!');
        }

        return redirect()->route($this->cIndexRoute);
    }

    public function update(SliderRequest $request, $id)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();

        return parent::_update($request, $id);
    }

}
