@extends('admin::_layouts.content',['selectedMenu'=>$cMenuKey])

@section('title')
    {!! ($item??false) ? 'Düzenle' : 'Yeni' !!}
@endsection

@section('content')
    @include('admin::_partials.tinymce')
    <div class="page-header">
        <div class="page-header-content header-elements-md-inline">
            <div class="page-title d-flex">
                <h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">Referans İçeriği</span> - {!! ($item??false) ? 'Düzenle' : 'Yeni' !!}</h4>
                <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
            </div>
        </div>
    </div>
    <div class="content pt-0 ">
        {!! html()->model($item ?? [])->form($method,$methodURL)->open() !!}
        {!! skey() !!}
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header header-elements-inline">
                        <h5 class="card-title">Referans Bilgileri</h5>
                        <div class="header-elements">
                            <div class="list-icons">
                                <a class="list-icons-item" data-action="collapse"></a>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">

                        @if(config('nette-lang.enable'))
                            <div class="tabbable">
                                <ul class="nav nav-tabs nav-justified">
                                    @foreach (\LaravelLocalization::getSupportedLocales() as $key => $lang)
                                        <li class="nav-item">
                                            <a aria-controls="lang_{{$key}}" aria-selected="true" class="nav-link @if($key == LaravelLocalization::getCurrentLocale()) active @endif" data-toggle="tab" href="#lang_{{$key}}" id="lang-{{$key}}-tab" role="tab">{{ $lang['native'] }}</a>
                                        </li>
                                    @endforeach
                                </ul>

                                <div class="tab-content">
                                    @foreach (\LaravelLocalization::getSupportedLocales() as $key => $lang)
                                        <div class="tab-pane @if($key == LaravelLocalization::getCurrentLocale()) active @endif" id="lang_{{$key}}">
                                            <div class="f-group">
                                                {!! html()->label('İçerik Başlığı ('.$lang['native'].')')->for('name') !!}
                                                {!! html()->text('name_'.$key)->placeholder('İçerik Başlığı ('.$lang['native'].')')->addClass('form-control'); !!}
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @else
                            <div class="f-group">
                                {!! html()->label('İçerik Başlığı')->for('name') !!}
                                {!! html()->text('name')->placeholder('İçerik Başlığı')->addClass('form-control'); !!}
                            </div>
                            <div class="f-group">
                                {!! html()->label('İçerik')->for('content') !!}
                                {!! html()->textarea('content')->placeholder('İçerik')->addClass('form-control')->data('editor','true') !!}
                            </div>
                        @endif
                    </div>
                </div>

            </div>
            <div class="col-xl-3 col-lg-12">
                @include('admin::_partials.sidebar.elements.files')

                @if(count($cSidebarModules ?? []))
                    @foreach($cSidebarModules as $sidebarModule)
                        @include($sidebarModule)
                    @endforeach
                @endif

                @if($cOrderable)
                    <div class="card">
                        <div class="card-header header-elements-inline">
                            <h5 class="card-title">
                                Sıralama
                            </h5>
                        </div>
                        <div class="card-body">

                            <div class="f-group">
                                {!! html()->label('Sıra')->for($cOrderableColumn ?? 'order_number') !!}
                                {!! html()->text($cOrderableColumn ?? 'order_number')->placeholder('Sıra')->addClass('form-control')->value($item->$cOrderableColumn ?? 0); !!}
                            </div>

                        </div>
                    </div>
                @endif
            </div>
        </div>
        <div class="f-save-bar">
            <div class="buttons">
                {!! backbtn(url()->previous()) !!}
                {!! savebtn() !!}
            </div>
        </div>
        {!! html()->form()->close() !!}
    </div>
@endsection

