<?php

Route::group(['prefix' => 'references', 'as' => 'references.','namespace' => 'App\Packages\References'], function () {
    Route::get('/',                                 ['as' => 'index',           'uses' => 'ReferencesController@index']);
    Route::get('/create',                           ['as' => 'create',          'uses' => 'ReferencesController@create']);
    Route::post('/',                                ['as' => 'store',           'uses' => 'ReferencesController@store']);
    Route::get('/{id}/edit',                        ['as' => 'edit',            'uses' => 'ReferencesController@edit']);
    Route::match(['put', 'patch'], '/{id}/update',  ['as' => 'update',          'uses' => 'ReferencesController@update']);
    Route::post('/{id}/publish',                    ['as' => 'publish',         'uses' => 'ReferencesController@publish']);
    Route::delete('/{id}',                          ['as' => 'destroy',         'uses' => 'ReferencesController@destroy']);
    Route::post('/batchdestroy',                    ['as' => 'batchdestroy',    'uses' => 'ReferencesController@batchDestroy']);
    Route::post('/orderable',                       ['as' => 'orderable',       'uses' => 'ReferencesController@orderable']);
    Route::get('/{id}',                             ['as' => 'show',            'uses' => 'ReferencesController@show']);
    Route::post('/{id}/ordermedia',                 ['as' => 'ordermedia',      'uses' => 'ReferencesController@orderMedia']);
    Route::post('/{id}/updatemedia',                ['as' => 'updatemedia',     'uses' => 'ReferencesController@updateMedia']);
    Route::post('/{id}/deletemedia',                ['as' => 'deletemedia',     'uses' => 'ReferencesController@deleteMedia']);
});
