<?php

use Illuminate\Support\Facades\Schema;
use Nette\Multilingual\Database\Schema\ExtendedBlueprint;
use Illuminate\Database\Migrations\Migration;

class CreateReferencesTable extends Migration
{

    public function up()
    {
        $schema = \DB::connection()->getSchemaBuilder();

        $schema->blueprintResolver(function ($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });

        $schema->create('references', function (ExtendedBlueprint $table) {
            $table->bigIncrements('id');
            $table->integer('order_number')->default(0);
            $table->multiLangString('name', false);
            $table->boolean('homepage_show')->default(true);
            $table->boolean('online_market')->default(true);
            $table->boolean('offline_market')->default(true);
            $table->multiLangText('url', true);
            $table->bigInteger('photo_id')->nullable();
            $table->boolean('status')->default(true);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('references');
    }
}
