<?php

namespace App\Packages\References;

use App\Packages\References\Models\References;
use App\Packages\References\Requests\ReferencesRequest;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController;
use UploadManager;


class ReferencesController extends AdminBaseController
{
    public $cTitle = 'Referans İçerikleri';
    public $cMenuKey = 'references';

    public $cBreadcrumb = [
        'name'  => 'Referanslar',
        'route' => 'admin.references.index',
    ];

    public $cModel = References::class;
    public $cModelName = 'Referans İçerikleri';

    public $cKey = 'references';

    public $cBladeKey = null;

    public $cIndexBlade = null;
    public $cIndexRoute = 'admin.references.index';
    public $cIndexTitle = 'Liste';

    public $cShow = true;
    public $cShowRoute = 'admin.references.show';
    public $cShowTitle = 'Görüntüle';
    public $cShowBlade = null;
    public $cShowPermission = 'references.view';


    public $cCreate = true;
    public $cCreateBlade = 'References::create';
    public $cCreateRoute = 'admin.references.create';
    public $cCreateTitle = 'Yeni ';
    public $cCreateMethodRoute = 'admin.references.store';
    public $cCreatePermission = 'references.create';

    public $cEdit = true;
    public $cEditRoute = 'admin.references.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.references.update';
    public $cEditPermission = 'references.edit';

    public $cPublish = true;
    public $cPublishRoute = 'admin.references.publish';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'references.publish';

    public $cDelete = true;
    public $cDeleteRoute = 'admin.references.destroy';
    public $cDeletePermission = 'references.delete';

    public $cBatchDelete = true;
    public $cBatchDeleteRoute = 'admin.references.batchdestroy';

    public $cOrderable = true;
    public $cOrderableColumn = 'order_number';
    public $cOrderableRoute = 'admin.references.orderable';

    public $cSortable = false;
    public $cSortableColumn = 'order_number';


    public $cOrderMediaRoute = 'admin.references.ordermedia';
    public $cUpdateMediaRoute = 'admin.references.updatemedia';
    public $cDeleteMediaRoute = 'admin.references.deletemedia';


    public $cFields = [
        'id'            => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name_tr'       => ['name' => 'Referans Adı'],
        'online_market' => ["name" => "Durum"],
    ];
    public $cMultiLangFields = [
    ];

    public $cFieldMutators = [
        'online_market' => ['method' => 'isPartner', 'parameter' => 'object'],
    ];

    public $cFilterable = false;
    public $filters = [
        'field' => [
            'name'     => 'referans Adı',
            'type'     => 'text',
            'operator' => 'like',
        ],
    ];


    public $cModuleFiles = [
        [
            'name'         => 'referans resmi',
            'type'         => 'img',
            'key'          => 'references',
            'database_key' => 'photo_id',
            'multiple'     => false,
            'attach_func'  => 'photo',
        ],


    ];

    public $cSidebarModules = [
        'References::_common.status',
    ];

    public function __construct()
    {
        parent::__construct();
    }


    public function store(ReferencesRequest $request)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        $data                  = parent::_store($request, true);

        if ($data) {
            $request->session()->flash('success', 'Kayıt İşlemi Başarılı!');
        }

        return redirect()->route($this->cIndexRoute);
    }

    public function update(ReferencesRequest $request, $id)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();

        return parent::_update($request, $id);
    }


}
