<?php

namespace App\Packages\References\Models;

use Cviebrock\EloquentSluggable\Sluggable;
use Nette\Admin\Models\BaseModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Nette\Admin\Traits\SlugTrait;
use Nette\Multilingual\Traits\MultiLingualModel;
use Nette\Upload\Models\Media;

class References extends BaseModel
{
    use SoftDeletes;
    use MultiLingualModel;

    public $table = 'references';

    protected $fillable = ['photo_id', 'status', 'meta', 'homepage_show', 'online_market', 'offline_market', 'order_number'];

    protected $multiLingualFillable = [
        'name',
    ];


    protected $casts = [
        'meta' => 'array',
    ];

    public static $checks = [
        'homepage_show',
        'online_market',
        'offline_market',
        'status',
    ];

    protected $with = ['photo'];


    protected $appends = [];

    public static $rules = [];

    public static $multiLingualRules = [
        'name' => 'required',
//        'url' => 'required',
    ];

    public static $attr = [
        'name' => 'Başlık',
        'url'  => 'URL',
    ];

    public function photo()
    {
        return $this->hasOne(Media::class, 'id', 'photo_id');
    }

    public function getPhoto($variation = null)
    {
        return $this->photo_id ? str_replace("\\", "/", $this->photo->url()) : _asset('images/no-image.svg');
    }

    public function sluggable()
    {
        return $this->autoSluggable();
    }

    public function scopeForHome($query)
    {
        return $query->where("homepage_show", true)->orderBy("order_number");
    }

    public function scopeOnline($query)
    {
        return $query->where("online_market", true)->orderBy("order_number");
    }

    public function scopeOffline($query)
    {
        return $query->where("offline_market", true)->orderBy("order_number");
    }


}
