<?php

use Illuminate\Support\Facades\Schema;
use Nette\Multilingual\Database\Schema\ExtendedBlueprint;
use Illuminate\Database\Migrations\Migration;

class CreateRedirectsPackage extends Migration
{

    public function up()
    {
        $schema = \DB::connection()->getSchemaBuilder();

        // replace blueprint
        $schema->blueprintResolver(function ($table, $callback) {
            return new ExtendedBlueprint($table, $callback);
        });

        $schema->create('redirects', function (ExtendedBlueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->multiLangString('name', true);
            $table->multiLangText('content', true);
            $table->multiLangString('link', true);
            $table->bigInteger('photo_id')->unsigned()->nullable();
            $table->bigInteger('banner_id')->unsigned()->nullable();
            $table->integer('author')->nullable();
            $table->integer('edit_author')->nullable();
            $table->integer('order_number')->default(0)->nullable();
            $table->boolean('shareable')->default(true)->index();
            $table->enum('publish_status', [1, 0])->default(1);
            $table->boolean('status')->default(false);
            $table->timestamp('date')->nullable();
            $table->text('meta')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }


    public function down()
    {
        Schema::dropIfExists('redirects');
    }
}
