@extends('admin::_layouts.content',['selectedMenu'=>'product_feature'])

@section('title')
    {!! ($item??false) ? 'Düzenle' : 'Yeni' !!}
@endsection

@section('content')
    @include('admin::_partials.tinymce')
    <div class="page-header">
        <div class="page-header-content header-elements-md-inline">
            <div class="page-title d-flex">
                <h4><i class="icon-arrow-left52 mr-2"></i> <span class="font-weight-semibold">Ürün Özellikleri</span>
                    - {!! ($item??false) ? 'Düzenle' : 'Yeni' !!}</h4>
                <a href="#" class="header-elements-toggle text-default d-md-none"><i class="icon-more"></i></a>
            </div>
        </div>
    </div>
    <div class="content pt-0 ">
        {!! html()->model($item ?? [])->form($method,$methodURL)->open() !!}
        {{--{{dd($item)}}--}}
        {!! skey() !!}
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header header-elements-inline">
                        <h5 class="card-title">Ürün Özellikleri</h5>
                        <div class="header-elements">
                            <div class="list-icons">
                                <a class="list-icons-item" data-action="collapse"></a>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">

                        @if(config('nette-lang.enable'))
                            <div class="tabbable">
                                <ul class="nav nav-tabs nav-justified">
                                    @foreach (\LaravelLocalization::getSupportedLocales() as $key => $lang)
                                        <li class="nav-item">
                                            <a aria-controls="lang_{{$key}}" aria-selected="true" class="nav-link @if($key == LaravelLocalization::getCurrentLocale()) active @endif" data-toggle="tab" href="#lang_{{$key}}" id="lang-{{$key}}-tab" role="tab">{{ $lang['native'] }}</a>                                        </li>
                                    @endforeach
                                </ul>

                                <div class="tab-content">
                                    @foreach (\LaravelLocalization::getSupportedLocales() as $key => $lang)

                                        <div class="tab-pane @if($key == LaravelLocalization::getCurrentLocale()) active @endif" id="lang_{{$key}}">
                                            <div class="f-group">
                                                {!! html()->label('Özellik Adı ('.$lang['native'].')')->for('name_'.$key) !!}
                                                {!! html()->text('name_'.$key)->placeholder('Özellik Adı ('.$lang['native'].')')->addClass('form-control'); !!}
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @else
                            <div class="f-group">
                                {!! html()->label('Sayfa Başlığı')->for('name') !!}
                                {!! html()->text('name')->placeholder('Sayfa Başlığı')->addClass('form-control'); !!}
                            </div>
                            <div class="f-group">
                                {!! html()->label('İçerik')->for('content') !!}
                                {!! html()->textarea('content')->placeholder('İçerik')->addClass('form-control')->data('editor','true') !!}
                            </div>
                        @endif
                    </div>

                </div>

            </div>
            @include('admin::_partials.sidebar._sidebar')

        </div>
        <div class="f-save-bar">
            <div class="buttons">
                {!! backbtn(url()->previous()) !!}
                {!! savebtn() !!}
            </div>
        </div>
        {!! html()->form()->close() !!}
    </div>
@endsection

@section('foot')
    <script type="text/javascript">
        $(function () {
            $(".f-group select.colors,.f-group select.bodysizes").select2({
                tags: true,
                // selectOnClose: true,
                //tokenSeparators: [",", " "],
            });
        });
    </script>
@endsection
