<?php

Route::group(['prefix' => 'product_feature', 'as' => 'product_feature.'], function () {
    Route::get('/',                                 ['as' => 'index',   'uses' => 'App\Packages\ProductFeature\ProductFeatureController@index']);
    Route::get('/create',                           ['as' => 'create',  'uses' => 'App\Packages\ProductFeature\ProductFeatureController@create']);
    Route::post('/',                                ['as' => 'store',   'uses' => 'App\Packages\ProductFeature\ProductFeatureController@store']);
    Route::get('/{id}/edit',                        ['as' => 'edit',   'uses' => 'App\Packages\ProductFeature\ProductFeatureController@edit']);
    Route::match(['put', 'patch'], '/{id}/update',  ['as' => 'update',  'uses' => 'App\Packages\ProductFeature\ProductFeatureController@update']);
    Route::post('/{id}/publish',                    ['as' => 'publish',   'uses' => 'App\Packages\ProductFeature\ProductFeatureController@publish']);
    Route::delete('/{id}',                          ['as' => 'destroy', 'uses' => 'App\Packages\ProductFeature\ProductFeatureController@destroy']);
    Route::post('/batchdestroy',                    ['as' => 'batchdestroy', 'uses' => 'App\Packages\ProductFeature\ProductFeatureController@batchDestroy']);
    Route::post('/orderable',                       ['as' => 'orderable', 'uses' => 'App\Packages\ProductFeature\ProductFeatureController@orderable']);
    Route::get('/{id}',                             ['as' => 'show',    'uses' => 'App\Packages\ProductFeature\ProductFeatureController@show']);
    Route::post('/{id}/ordermedia',                 ['as' => 'ordermedia',   'uses' => 'App\Packages\ProductFeature\ProductFeatureController@orderMedia']);
    Route::post('/{id}/updatemedia',                ['as' => 'updatemedia',   'uses' => 'App\Packages\ProductFeature\ProductFeatureController@updateMedia']);
    Route::post('/{id}/deletemedia',                ['as' => 'deletemedia',   'uses' => 'App\Packages\ProductFeature\ProductFeatureController@deleteMedia']);
    Route::post('/import',                          ['as' => 'importstore',   'uses' => 'App\Packages\ProductFeature\ProductFeatureController@importProduct']);
});
