<?php

namespace App\Packages\ProductFeature;


use App\Packages\Brand\Models\Brand;
use App\Packages\Category\Models\Category;
use App\Packages\Product\Models\Product;
use App\Packages\Product\Requests\ProductRequest;
use App\Packages\ProductFeature\Models\ProductFeature;
use App\Packages\ProductFeature\Requests\ProductFeatureRequest;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use Nette\Admin\Controllers\AdminBaseController as BaseController;
use FilterGenerator;
use App\Imports\ProductImport;

class ProductFeatureController extends BaseController
{
    public $cTitle = 'Özellikler';

    public $cMenuKey = 'product_feature';
    public $cModel = ProductFeature::class;
    public $cModelName = 'Özellikler';

    public $cKey = 'product_feature';

    public $cIndexBlade = "ProductFeature::index";
    public $cIndexRoute = 'admin.product_feature.index';
    public $cIndexTitle = 'Liste';
    public $cIndexPermission = 'product_feature.view';

    //region Create Settings
    public $cCreate = true;
    public $cCreateRoute = 'admin.product_feature.create';
    public $cCreateTitle = 'Yeni';
    public $cCreateMethodRoute = 'admin.product_feature.store';
    public $cCreatePermission = 'product_feature.create';
    public $cCreateBlade = 'ProductFeature::create';
    //endregion


    //region Edit Settings
    public $cEdit = true;
    public $cEditRoute = 'admin.product_feature.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.product_feature.update';
    public $cEditPermission = 'product_feature.edit';
    //endregion

    //region Publish Settings
    public $cPublish = true;
    public $cPublishRoute = 'admin.product_feature.publish';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'product_feature.publish';
    //endregion

    public $cOrderable = true;
    public $cOrderableColumn = 'order_number';
    public $cOrderableRoute = 'admin.product_feature.orderable';

    //region Delete Settings
    public $cDelete = true;
    public $cDeleteRoute = 'admin.product_feature.destroy';
    public $cDeleteTitle = 'Sil';
    public $cDeletePermission = 'product_feature.delete';
    //endregion

    public $cFields = [
        'id'      => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name_tr' => ['name' => 'Özellik Adı'],
    ];

    public $cFieldMutators = [
        'created_at' => 'globalDate',
    ];

    public $cSidebarModules = [
        'ProductFeature::_partials.status',
    ];

    public $cOrderMediaRoute = 'admin.product_feature.ordermedia';
    public $cUpdateMediaRoute = 'admin.product_feature.updatemedia';
    public $cDeleteMediaRoute = 'admin.product_feature.deletemedia';

    public $cModuleFiles = [
        [
            'name'         => 'Özellik Resmi',
            'type'         => 'img',
            'key'          => 'feature',
            'database_key' => 'photo_id',
            'multiple'     => false,
            'attach_func'  => 'photo',
        ],
    ];

    public $cFilterable = true;

    public $filters = [
        'name' => [
            'name'     => 'Ürün Adı',
            'type'     => 'text',
            'operator' => 'like',
        ],
    ];

    public function __construct()
    {
        view()->share('products', Product::all()->pluck('name_tr', 'id')->toArray());
        parent::__construct();
    }

    public function store(ProductFeatureRequest $request)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        $request["product_id"] = 0;
        $data                  = parent::_store($request, true);

        if ($data) {
            $request->session()->flash('success', 'Kayıt İşlemi Başarılı!');
        }

        return redirect()->route($this->cIndexRoute);
    }

    public function update(ProductFeatureRequest $request, $id)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        $request["product_id"] = 0;

        return parent::_update($request, $id);

    }

}
