<?php

namespace App\Packages\ProductFeature\Models;

use App\Packages\Category\Models\Category;
use App\Packages\Product\Models\Product;
use Nette\Admin\Models\BaseModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Nette\Admin\Traits\SlugTrait;
use Nette\Multilingual\Traits\MultiLingualModel;
use Nette\Upload\Models\Media;

class ProductFeature extends BaseModel
{
    use SoftDeletes;
    use MultiLingualModel;

    protected $table = 'product_features';

    protected $multiLingualFillable = [
        "name",
    ];

    protected $fillable = [
        'product_id',
        'photo_id',
        'order_number',
        'author',
        'edit_author',
        'status',
    ];

    protected $hidden = [

    ];

    protected $casts = [
//        'meta' => 'array',
    ];

    protected $with = ['photo'];

    protected $appends = ['date_published', 'date_modified', 'created_at_str'];

    public static $slug = [
    ];

    public static $multiLingualSlug = [
    ];

    public static $checks = [
        'status',
    ];

    public static $zeros = [

    ];

    public static $rules = [
//        'product_id' => 'required',
    ];

    public static $multiLingualRules = [
        'name' => "required",
    ];

    public static $attr = [
        'name' => 'Ürün adı',
    ];

    public function photo()
    {
        return $this->hasOne(Media::class, 'id', 'photo_id');
    }

    public function getPhoto($variation = null)
    {
        return $this->photo_id ? str_replace("\\", "/", $this->photo->url()) : null;
    }

    public function product()
    {
        return $this->hasOne(Product::class, 'id', 'product_id');
    }

}
