<?php

Route::group(['prefix' => 'product', 'as' => 'product.'], function () {
    Route::get('/',                                 ['as' => 'index',   'uses' => 'App\Packages\Product\ProductController@index']);
    Route::get('/create',                           ['as' => 'create',  'uses' => 'App\Packages\Product\ProductController@create']);
    Route::post('/',                                ['as' => 'store',   'uses' => 'App\Packages\Product\ProductController@store']);
    Route::get('/{id}/edit',                        ['as' => 'edit',   'uses' => 'App\Packages\Product\ProductController@edit']);
    Route::match(['put', 'patch'], '/{id}/update',  ['as' => 'update',  'uses' => 'App\Packages\Product\ProductController@update']);
    Route::post('/{id}/publish',                    ['as' => 'publish',   'uses' => 'App\Packages\Product\ProductController@publish']);
    Route::delete('/{id}',                          ['as' => 'destroy', 'uses' => 'App\Packages\Product\ProductController@destroy']);
    Route::post('/batchdestroy',                    ['as' => 'batchdestroy', 'uses' => 'App\Packages\Product\ProductController@batchDestroy']);
    Route::post('/orderable',                       ['as' => 'orderable', 'uses' => 'App\Packages\Product\ProductController@orderable']);
    Route::get('/{id}',                             ['as' => 'show',    'uses' => 'App\Packages\Product\ProductController@show']);
    Route::post('/{id}/ordermedia',                 ['as' => 'ordermedia',   'uses' => 'App\Packages\Product\ProductController@orderMedia']);
    Route::post('/{id}/updatemedia',                ['as' => 'updatemedia',   'uses' => 'App\Packages\Product\ProductController@updateMedia']);
    Route::post('/{id}/deletemedia',                ['as' => 'deletemedia',   'uses' => 'App\Packages\Product\ProductController@deleteMedia']);
    Route::post('/import',                          ['as' => 'importstore',   'uses' => 'App\Packages\Product\ProductController@importProduct']);
});
