<?php

namespace App\Packages\Product;


use App\Packages\Area\Models\Area;
use App\Packages\Category\Models\Category;
use App\Packages\Collection\Models\Collection;
use App\Packages\Material\Models\Material;
use App\Packages\Product\Models\Product;
use App\Packages\Product\Requests\ProductRequest;
use App\Packages\ProductFeature\Models\ProductFeature;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use Nette\Admin\Controllers\AdminBaseController as BaseController;
use FilterGenerator;
use App\Imports\ProductImport;

class ProductController extends BaseController
{
    public $cTitle = 'Ürünler';

    public $cMenuKey = 'product';
    public $cModel = Product::class;
    public $cModelName = 'Ürünler';

    public $cKey = 'product';

    public $cIndexBlade = "Product::index";
    public $cIndexRoute = 'admin.product.index';
    public $cIndexTitle = 'Liste';
    public $cIndexPermission = 'product.view';

    //region Create Settings
    public $cCreate = true;
    public $cCreateRoute = 'admin.product.create';
    public $cCreateTitle = 'Yeni';
    public $cCreateMethodRoute = 'admin.product.store';
    public $cCreatePermission = 'product.create';
    public $cCreateBlade = 'Product::create';
    //endregion

    //region Edit Settings
    public $cEdit = true;
    public $cEditRoute = 'admin.product.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.product.update';
    public $cEditPermission = 'product.edit';
    //endregion

    //region Publish Settings
    public $cPublish = true;
    public $cPublishRoute = 'admin.product.publish';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'product.publish';
    //endregion

    public $cOrderable = true;
    public $cOrderableColumn = 'order_number';
    public $cOrderableRoute = 'admin.product.orderable';

    //region Delete Settings
    public $cDelete = true;
    public $cDeleteRoute = 'admin.product.destroy';
    public $cDeleteTitle = 'Sil';
    public $cDeletePermission = 'product.delete';
    //endregion

    public $cFields = [
        'id'          => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name_tr'     => ['name' => 'Ürün Adı'],
        'category_id' => ['name' => 'Kategori', 'size' => 'medium'],
    ];

    public $cFieldMutators = [
        'created_at'  => 'globalDate',
        'name'        => ['method' => 'frontUrl', 'parameter' => 'object'],
        'category_id' => ['method' => 'categoryUrller', 'parameter' => 'object'],
//        'brand_id' => ['method' => 'brandUrl', 'parameter' => 'object'],
    ];

    public $cSidebarModules = [
        'Category::_common.relation',
        'Product::_common.relation',
//        'Product::_common.relation',
        'Product::_partials.status',
        'Product::_partials.info',
    ];

    public $cOrderMediaRoute = 'admin.product.ordermedia';
    public $cUpdateMediaRoute = 'admin.product.updatemedia';
    public $cDeleteMediaRoute = 'admin.product.deletemedia';

    public $cModuleFiles = [
        [
            'name'         => 'Ürun Resmi',
            'type'         => 'img',
            'key'          => 'product_cover',
            'database_key' => 'cover_id',
            'multiple'     => false,
            'attach_func'  => 'cover',
        ],
        [
            'name'         => 'Ürun 1. Mini png',
            'type'         => 'img',
            'key'          => 'product_mini1',
            'database_key' => 'mini_png1',
            'multiple'     => false,
            'attach_func'  => 'mini1',
        ],
        [
            'name'         => 'Ürun 2. Mini png',
            'type'         => 'img',
            'key'          => 'product_mini2',
            'database_key' => 'mini_png2',
            'multiple'     => false,
            'attach_func'  => 'mini2',
        ],
        [
            'name'        => 'Ürün Galerisi',
            'type'        => 'img',
            'key'         => 'product_gallery',
            'multiple'    => true,
            'attach_func' => 'images',
        ],
    ];

    public $cFilterable = true;

    public $filters = [
        'name_tr' => [
            'name'     => 'Ürün Adı',
            'type'     => 'text',
            'operator' => 'like',
        ],
    ];


    public function __construct()
    {
        view()->share('categories', Category::all()->pluck('name_tr', 'id')->toArray());
        view()->share('features', ProductFeature::all()->pluck('name_tr', 'id')->toArray());
        parent::__construct();
    }

    public function store(ProductRequest $request)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        $data                  = parent::_store($request, true);

        if ($data) {
            $features = $request->features ?? [];
            $data->features()->sync($features);
            $request->session()->flash('success', 'Kayıt İşlemi Başarılı!');
        }

        return redirect()->route($this->cIndexRoute);
    }

    public function update(ProductRequest $request, $id)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();

        $data = parent::_update($request, $id, true);

        if ($data) {
            $features = $request->features ?? [];
            $data->features()->sync(array_values($features));
        }

        return parent::_update($request, $id);
    }


}
