<?php

namespace App\Packages\Product\Models;

use App\Packages\BodySize\Models\BodySize;
use App\Packages\Area\Models\Area;
use App\Packages\Category\Models\Category;
use App\Packages\Collection\Models\Collection;
use App\Packages\Color\Models\Color;
use App\Packages\Material\Models\Material;
use App\Packages\ProductFeature\Models\ProductFeature;
use Nette\Admin\Models\BaseModel;
use Cviebrock\EloquentSluggable\Sluggable;
use Nette\Multilingual\Traits\MultiLingualModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Nette\Admin\Traits\SlugTrait;
use Nette\Upload\Models\Media;

class Product extends BaseModel
{
    protected $table = 'products';

    use SoftDeletes;
    use Sluggable;
    use SlugTrait;
    use MultiLingualModel;


    protected $multiLingualFillable = [
        'name',
        'slug',
        'spot',
        'youtube_link',
        'content',
    ];

    protected $fillable = [
        'cover_id',
        'category_id',
        'mini_png1',
        'mini_png2',
        'detail_png1',
        'detail_png2',
        'color_style',
        'showroom',
        'order_number',
        'author',
        'edit_author',
        'publish_status',
        'status',
        'home_page_view',
        'lock',
        'meta',
    ];

    protected $hidden = [

    ];

    protected $casts = [
        'meta' => 'array',
    ];

    protected $with = ['photo'];

    protected $appends = ['date_published', 'date_modified', 'created_at_str'];

    public static $slug = [
//        'name' => 'slug',
    ];

    public static $multiLingualSlug = [
        'name' => 'slug',
    ];

    public static $checks = [
        'status',
        'home_page_view',
        'showroom'
    ];

    public static $zeros = [

    ];

    public static $rules = [
        'category_id' => 'required',
    ];

    public static $multiLingualRules = [
        'name' => 'required',
    ];

    public static $attr = [
        'name' => 'Kategori adı',
    ];

    public function sluggable()
    {
        return $this->autoSluggable();
    }


    public function cover()
    {
        return $this->hasOne(Media::class, 'id', 'cover_id');
    }

    public function getCover()
    {
        return $this->cover_id ? str_replace("\\", "/", $this->cover->url()) : _asset('images/no-image.svg');
    }


    public function mini1()
    {
        return $this->hasOne(Media::class, 'id', 'mini_png1');
    }

    public function getMini1()
    {
        return $this->mini_png1 ? str_replace("\\", "/", $this->mini1->url()) : _asset('images/no-image.svg');
    }


    public function mini2()
    {
        return $this->hasOne(Media::class, 'id', 'mini_png2');
    }

    public function getMini2()
    {
        return $this->mini_png2 ? str_replace("\\", "/", $this->mini2->url()) : _asset('images/no-image.svg');
    }

    public function detail1()
    {
        return $this->hasOne(Media::class, 'id', 'detail_png1');
    }

    public function getDetail1()
    {
        return $this->detail_png1 ? str_replace("\\", "/", $this->detail1->url()) : _asset('images/no-image.svg');
    }


    public function detail2()
    {
        return $this->hasOne(Media::class, 'id', 'detail_png2');
    }

    public function getDetail2()
    {
        return $this->detail_png2 ? str_replace("\\", "/", $this->detail2->url()) : _asset('images/no-image.svg');
    }






    public function photo()
    {
        return $this->hasOne(Media::class, 'id', 'photo_id');
    }



    public function getPhoto()
    {
        return $this->photo_id ? $this->photo->url() : _asset('images/no-image.svg');
    }

    public function category()
    {
        return $this->hasOne(Category::class, 'id', 'category_id');
    }

    public function url()
    {
        $params = ['slug' => $this->slug];

        return route('front.product.detail', $params);
    }

    public function images()
    {
        return $this->belongsToMany(Media::class, 'product_gallery', 'product_id', 'media_id')->withPivot('title', 'caption', 'order',
            'source')->orderBy('product_gallery.order', 'ASC');
    }

    public function features()
    {
        return $this->belongsToMany(ProductFeature::class, "feature_product", "product_id")->orderBy("order_number");
    }

}
