<?php

namespace App\Packages\FaqCat\Models;


use App\Packages\Faq\Models\Faq;
use App\Packages\Catalog\Models\Catalog;
use App\Packages\Product\Models\Product;
use Nette\Admin\Models\BaseModel;
use Cviebrock\EloquentSluggable\Sluggable;
use Nette\Multilingual\Traits\MultiLingualModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Nette\Admin\Traits\SlugTrait;
use Nette\Upload\Models\Media;

class FaqCat extends BaseModel
{
    use SoftDeletes;
    use Sluggable;
    use SlugTrait;

    use MultiLingualModel;

    protected $table = 'faq_cats';

    protected $multiLingualFillable = [
        'name',
        'slug',
        'content',
        'short_content',
        'long_content',
    ];

    protected $fillable = [
        'cover_id',
        'banner_id',
        'mini_png1',
        'mini_png2',
        'banner_id',
        'home_showroom',
        'photo_id',
        'author',
        'edit_author',
        'parent_id',
        'status',
        'home_page_view',
        'banner_id',
        'date',
        'meta',
        'style',
        'lock',
        'key',
        'subkey',
    ];

    protected $hidden = [

    ];

    protected $casts = [
        'meta' => 'array',
    ];

    protected $with = [];

    protected $appends = ['url', 'date_published', 'date_modified', 'created_at_str'];

    public static $slug = [
        //'name' => 'slug'
    ];

    public static $multiLingualSlug = [
        'name' => 'slug',
    ];

    public static $checks = [
        'status', 'home_page_view', 'home_showroom',
    ];

    public static $zeros = [

    ];

    public static $rules = [
    ];

    public static $multiLingualRules = [
        'name' => 'required',
    ];

    public static $attr = [
        'name' => 'Kategori adı',
    ];

    public function sluggable()
    {
        return $this->autoSluggable();
    }

    public function tags()
    {
        return $this->morphToMany(Tag::class, 'taggable', 'taggings');
    }

    public function faqs()
    {
        return $this->hasMany(Faq::class, 'faq_cat_id', 'id');
    }


    // Alt kategori sistemi

    public function childFaqCats()
    {
        return $this->hasMany(FaqCat::class, 'parent_id', 'id');
    }

    public function parentFaqCat()
    {
        return $this->hasOne(FaqCat::class, 'id', 'parent_id');
    }


    public function getParentFaqCatTree($id = null, $result = [])
    {
        if (is_null($id)) {
            $id = $this->id;
        }
        $obj = self::find($id);
        if ($obj) {
            if ($obj->parent_id != null) {
                $result[] = $obj->parentFaqCat;

                return $this->getParentFaqCatTree($obj->parent_id, $result);
            }
        }

        return $result;
    }

    public function getChildFaqCatTree($id = null, $result = [])
    {
        if (is_null($id)) {
            $id = $this->id;
        }
        $obj = self::find($id);
        if ($obj) {
            if ($obj->childFaqCats->count()) {
                foreach ($obj->childFaqCats as $childFaqCat) {
                    $catEntry = ['cat' => $childFaqCat];
                    if ($childFaqCat->childFaqCats->count()) {
                        $catEntry['childs'] = self::getChildFaqCatTree($childFaqCat->id, $result);
                    }
                    $result[] = $catEntry;
                }

                return $result;
            }
        }
    }

    public function level()
    {
        $parents = $this->getParentFaqCatTree();

        return count($parents) + 1;
    }


    public function url()
    {
        $params = ["id" => $this->id];

        return route('admin.faq_cat.edit', $params);
    }

    public function subUrl()
    {
        $params = ['slug' => $this->parentFaqCat->slug, 'subFaqCat' => $this->id];

        return route('front.faq_cat.detail', $params);
    }

}
