<?php

namespace App\Packages\FaqCat;

use App\Packages\FaqCat\Models\FaqCat;
use App\Packages\FaqCat\Models\Product;
use App\Packages\FaqCat\Requests\FaqCatRequest;
use App\Packages\FaqCat\Requests\InquiryRequest;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController as BaseController;
use FilterGenerator;

class FaqCatController extends BaseController
{
    public $cTitle = 'SSS Kategorileri';

    public $cMenuKey = 'faq_cat';
    public $cModel = FaqCat::class;
    public $cModelName = 'Kategori';

    public $cKey = 'faq_cat';

    public $cIndexBlade = "FaqCat::index";
    public $cIndexRoute = 'admin.faq_cat.index';
    public $cIndexTitle = 'Liste';
    public $cIndexPermission = 'faq_cat.view';

    //region Create Settings
    public $cCreate = true;
    public $cCreateRoute = 'admin.faq_cat.create';
    public $cCreateTitle = 'Yeni';
    public $cCreateMethodRoute = 'admin.faq_cat.store';
    public $cCreatePermission = 'faq_cat.create';
    public $cCreateBlade = 'FaqCat::create';
    //endregion


    //region Edit Settings
    public $cEdit = true;
    public $cEditRoute = 'admin.faq_cat.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.faq_cat.update';
    public $cEditPermission = 'faq_cat.edit';
    //endregion

    public $cOrderMediaRoute = 'admin.faq_cat.ordermedia';
    public $cUpdateMediaRoute = 'admin.faq_cat.updatemedia';
    public $cDeleteMediaRoute = 'admin.faq_cat.deletemedia';


    public $cOrderable = true;
    public $cOrderableColumn = 'order_number';
    public $cOrderableRoute = 'admin.faq_cat.orderable';


    //region Publish Settings
    public $cPublish = true;
    public $cPublishRoute = 'admin.faq_cat.publish';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'faq_cat.publish';
    //endregion


    //region Delete Settings
    public $cDelete = true;
    public $cDeleteRoute = 'admin.faq_cat.destroy';
    public $cDeleteTitle = 'Sil';
    public $cDeletePermission = 'faq_cat.delete';
    //endregion

    public $cFields = [
        'id'        => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name_tr'   => ['name' => 'Kategori Adı'],
        'parent_id' => ['name' => 'İlişkili Kategori', 'size' => 'medium'],
        'lock'      => ['name' => 'Kilitli', 'size' => 'mini'],
    ];

    public $cFieldMutators = [
//        'faq_cat_id' => 'videoFaqCatName',
        'created_at' => 'globalDate',
        'parent_id'  => ['method' => 'parentName', 'parameter' => 'object'],
        'name'       => ['method' => 'frontUrl', 'parameter' => 'object'],
        'lock'       => 'isLocked',
    ];

    public $cSidebarModules = [
        'FaqCat::_partials.status',
        'FaqCat::_partials.faq_cat',
    ];


    public $cModuleFiles = [];

    public $cFilterable = true;

    public $filters = [
        'name_tr' => [
            'name'     => 'Kategori Adı',
            'type'     => 'text',
            'operator' => 'like',
        ],
    ];


    public function __construct()
    {
        view()->share('faq_cats', FaqCat::published()->get()->pluck('name_tr', 'id')->toArray());
        parent::__construct();
    }

    public function store(FaqCatRequest $request)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        $data                  = parent::_store($request, true);

        if ($data) {
            $request->session()->flash('success', 'Kayıt İşlemi Başarılı!');
        }

        return redirect()->route($this->cIndexRoute);
    }

    public function update(FaqCatRequest $request, $id)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();

        return parent::_update($request, $id);
    }

}
