<?php

namespace App\Packages\Faq\Models;


use App\Packages\FaqCat\Models\FaqCat;
use Nette\Admin\Models\BaseModel;
use Cviebrock\EloquentSluggable\Sluggable;
use Nette\Admin\Models\Page;
use Nette\Multilingual\Traits\MultiLingualModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Nette\Admin\Traits\SlugTrait;
use Nette\Upload\Models\Media;

class Faq extends BaseModel
{
    use SoftDeletes;
    use MultiLingualModel;

    protected $table = 'faq';

    protected $multiLingualFillable = [

        'name',
        'content',

    ];

    protected $fillable = [

        'author',
        'edit_author',
        'status',
        'publish_status',
        'photo_id',
        'created_at',
        'order_number',
        'faq_cat_id',
    ];

    protected $hidden = [

    ];

    protected $casts = [
        'meta' => 'array',
    ];

    protected $with = ['photo'];

    protected $appends = ['date_published', 'date_modified', 'created_at_str'];


    public static $checks = [
        'status',
    ];

    public static $zeros = [

    ];

    public static $rules = [
//        'name' => 'required',
    ];

    public static $multiLingualRules = [
        'name' => 'required',
    ];

    public static $attr = [
        'name' => 'Slide adı',
    ];

    public function photo()
    {
        return $this->hasOne(Media::class, 'id', 'photo_id');
    }

    public function getPhoto()
    {
        return $this->photo_id ? $this->photo->url() : _asset('images/no-image.svg');
    }

    public function replacePhotoUrl()
    {
        return $this->photo ? str_replace('\\', '/', $this->photo->url()) : '#';
    }

    public function category()
    {
        return $this->hasOne(FaqCat::class, 'id', 'faq_cat_id')->first();
    }


}
