<?php

namespace App\Packages\Faq;

use App\Packages\Faq\Requests\FaqRequest;
use App\Packages\Faq\Models\Faq;
use App\Packages\FaqCat\Models\FaqCat;
use Carbon\Carbon;
use Nette\Admin\Models\Page;
use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController as BaseController;
use FilterGenerator;

class FaqController extends BaseController
{
    public $cTitle = 'Sık Sorulan Sorular';

    public $cMenuKey = 'faq';
    public $cModel = Faq::class;
    public $cModelName = 'Faq';

    public $cKey = 'faq';

    public $cIndexBlade = null;
    public $cIndexRoute = 'admin.faq.index';
    public $cIndexTitle = 'Liste';
    public $cIndexPermission = 'faq.view';

    //region Create Settings
    public $cCreate = true;
    public $cCreateRoute = 'admin.faq.create';
    public $cCreateTitle = 'Yeni';
    public $cCreateMethodRoute = 'admin.faq.store';
    public $cCreatePermission = 'faq.create';
    public $cCreateBlade = 'Faq::create';
    //endregion


    //region Edit Settings
    public $cEdit = true;
    public $cEditRoute = 'admin.faq.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.faq.update';
    public $cEditPermission = 'faq.edit';
    //endregion

    //region Publish Settings
    public $cPublish = true;
    public $cPublishRoute = 'admin.faq.publish';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'faq.publish';
    //endregion

    public $cOrderable = true;
    public $cOrderableColumn = 'order_number';
    public $cOrderableRoute = 'admin.faq.orderable';

    //region Delete Settings
    public $cDelete = true;
    public $cDeleteRoute = 'admin.faq.destroy';
    public $cDeleteTitle = 'Sil';
    public $cDeletePermission = 'faq.delete';
    //endregion

    public $cFields = [
        'id'          => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name_tr'     => ['name' => 'Soru'],
        'faq_cats_id' => ['name' => 'kategori'],
    ];

    public $cFieldMutators = [
        'created_at' => 'globalDate',
        'faq_cats_id' => ['method' => 'cats', 'parameter' => 'object']
    ];

    public $cSidebarModules = [
        'Faq::_partials.status',
        '_Common::info',
    ];


    public $cModuleFiles = [

    ];

    public $cFilterable = false;


    public function __construct()
    {
        view()->share('faq_cats', FaqCat::all()->pluck('name_tr', 'id')->toArray());
        parent::__construct();
    }


    public function store(FaqRequest $request)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        $request['page_key']   = "homepage";
        $data                  = parent::_store($request, true);

        if ($data) {
            $request->session()->flash('success', 'Kayıt İşlemi Başarılı!');
        }

        return redirect()->route($this->cIndexRoute);
    }

    public function update(FaqRequest $request, $id)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();

        return parent::_update($request, $id);
    }

}
