<?php

Route::group(['prefix' => 'cities', 'as' => 'cities.'], function () {
    Route::get('/',                                 ['as' => 'index',   'uses' => 'App\Packages\Cities\CitiesController@index']);
    Route::get('/create',                           ['as' => 'create',  'uses' => 'App\Packages\Cities\CitiesController@create']);
    Route::post('/',                                ['as' => 'store',   'uses' => 'App\Packages\Cities\CitiesController@store']);
    Route::get('/{id}/edit',                        ['as' => 'edit',   'uses' => 'App\Packages\Cities\CitiesController@edit']);
    Route::match(['put', 'patch'], '/{id}/update',  ['as' => 'update',  'uses' => 'App\Packages\Cities\CitiesController@update']);
    Route::post('/{id}/publish',                    ['as' => 'publish',   'uses' => 'App\Packages\Cities\CitiesController@publish']);
    Route::delete('/{id}',                          ['as' => 'destroy', 'uses' => 'App\Packages\Cities\CitiesController@destroy']);
    Route::post('/batchdestroy',                    ['as' => 'batchdestroy', 'uses' => 'App\Packages\Cities\CitiesController@batchDestroy']);
    Route::post('/orderable',                       ['as' => 'orderable', 'uses' => 'App\Packages\Cities\CitiesController@orderable']);
    Route::get('/{id}',                             ['as' => 'show',    'uses' => 'App\Packages\Cities\CitiesController@show']);
});
