<?php

namespace App\Packages\Cities\Models;


use Nette\Admin\Models\BaseModel;
use Cviebrock\EloquentSluggable\Sluggable;
use Nette\Multilingual\Traits\MultiLingualModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Nette\Admin\Traits\SlugTrait;
use Nette\Upload\Models\Media;

class Cities extends BaseModel
{
    use SoftDeletes;
    use MultiLingualModel;

    protected $table = 'cities';

    protected $multiLingualFillable = [
        'name',
        'body',
    ];

    protected $fillable = [
        'author',
        'edit_author',
        'status',
        'lock',
        'order_number',
        'meta',
        'created_at',
        'id'
    ];
    protected $hidden = [];

    protected $casts = ['meta' => 'array'];

    protected $with = [];

    protected $appends = ['date_published', 'date_modified', 'created_at_str'];

    public static $slug = [];

    public static $multiLingualSlug = [];

    public static $checks = ['status'];

    public static $zeros = [];

    public static $rules = [];

    public static $multiLingualRules = [
        'name' => 'required',
    ];

    public static $attr = [
        'name' => 'Şehir adı',
    ];
}
