<?php

namespace App\Packages\Cities;

use App\Packages\Cities\Requests\CitiesRequest;
use App\Packages\Cities\Models\Cities;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController as BaseController;
use FilterGenerator;

class CitiesController extends BaseController
{
    public $cTitle = 'Şehirler';

    public $cMenuKey = 'cities';
    public $cModel = Cities::class;
    public $cModelName = 'cities';

    public $cKey = 'cities';

    public $cIndexBlade = null;
    public $cIndexRoute = 'admin.cities.index';
    public $cIndexTitle = 'Liste';
    public $cIndexPermission = 'cities.view';

    //region Create Settings
    public $cCreate = true;
    public $cCreateRoute = 'admin.cities.create';
    public $cCreateTitle = 'Yeni';
    public $cCreateMethodRoute = 'admin.cities.store';
    public $cCreatePermission = 'cities.create';
    public $cCreateBlade = 'Cities::create';
    //endregion

    public $cOrderable = true;
    public $cOrderableColumn = 'order_number';
    public $cOrderableRoute = 'admin.cities.orderable';
    //region Edit Settings
    public $cEdit = true;
    public $cEditRoute = 'admin.cities.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.cities.update';
    public $cEditPermission = 'cities.edit';
    //endregion

    //region Publish Settings
    public $cPublish = true;
    public $cPublishRoute = 'admin.cities.publish';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'cities.publish';
    //endregion


    //region Delete Settings
    public $cDelete = true;
    public $cDeleteRoute = 'admin.cities.destroy';
    public $cDeleteTitle = 'Sil';
    public $cDeletePermission = 'cities.delete';
    //endregion

    public $cFields = [
        'id'      => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name_tr' => ['name' => 'Başlık'],
    ];

    public $cFieldMutators = [];

    public $cSidebarModules = [
        'Cities::_common.status',
        'Cities::_common.info',
    ];

    public $cModuleFiles = [];

    public $cFilterable = false;

    public function __construct()
    {
        parent::__construct();
    }

    public function store(CitiesRequest $request)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        $data                  = parent::_store($request, true);

        if ($data) {
            $request->session()->flash('success', 'Kayıt İşlemi Başarılı!');
        }

        return redirect()->route($this->cIndexRoute);
    }

    public function update(CitiesRequest $request, $id)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();

        return parent::_update($request, $id);
    }

}
