<?php

namespace App\Packages\Category\Models;


use App\Packages\Catalog\Models\Catalog;
use App\Packages\Product\Models\Product;
use Nette\Admin\Models\BaseModel;
use Cviebrock\EloquentSluggable\Sluggable;
use Nette\Multilingual\Traits\MultiLingualModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Nette\Admin\Traits\SlugTrait;
use Nette\Upload\Models\Media;

class Category extends BaseModel
{
    use SoftDeletes;
    use Sluggable;
    use SlugTrait;

    use MultiLingualModel;

    protected $table = 'categories';

    protected $multiLingualFillable = [
        'name',
        'slug',
        'content',
        'short_content',
        'long_content',
    ];

    protected $fillable = [
        'cover_id',
        'banner_id',
        'mini_png1',
        'mini_png2',
        'banner_id',
        'home_showroom',
        'photo_id',
        'author',
        'edit_author',
        'parent_id',
        'status',
        'home_page_view',
        'banner_id',
        'date',
        'meta',
        'style',
    ];

    protected $hidden = [

    ];

    protected $casts = [
        'meta' => 'array',
    ];

    protected $with = [];

    protected $appends = ['url', 'date_published', 'date_modified', 'created_at_str'];

    public static $slug = [
        //'name' => 'slug'
    ];

    public static $multiLingualSlug = [
        'name' => 'slug',
    ];

    public static $checks = [
        'status', 'home_page_view', 'home_showroom',
    ];

    public static $zeros = [

    ];

    public static $rules = [
    ];

    public static $multiLingualRules = [
        'name' => 'required',
    ];

    public static $attr = [
        'name' => 'Kategori adı',
    ];

    public function sluggable()
    {
        return $this->autoSluggable();
    }

    public function tags()
    {
        return $this->morphToMany(Tag::class, 'taggable', 'taggings');
    }

    public function products()
    {
        return $this->hasMany(Product::class, 'category_id', 'id')->orderBy("order_number")->where("status", 1);
    }

    public function menuProducts()
    {
        return $this->hasMany(Product::class, 'category_id', 'id')->where('showroom', 1)->where("status", 1)->get();
    }

    // Alt kategori sistemi

    public function childCategories()
    {
        return $this->hasMany(Category::class, 'parent_id', 'id');
    }

    public function parentCategory()
    {
        return $this->hasOne(Category::class, 'id', 'parent_id');
    }


    public function getParentCategoryTree($id = null, $result = [])
    {
        if (is_null($id)) {
            $id = $this->id;
        }
        $obj = self::find($id);
        if ($obj) {
            if ($obj->parent_id != null) {
                $result[] = $obj->parentCategory;

                return $this->getParentCategoryTree($obj->parent_id, $result);
            }
        }

        return $result;
    }

    public function getChildCategoryTree($id = null, $result = [])
    {
        if (is_null($id)) {
            $id = $this->id;
        }
        $obj = self::find($id);
        if ($obj) {
            if ($obj->childCategories->count()) {
                foreach ($obj->childCategories as $childCategory) {
                    $catEntry = ['cat' => $childCategory];
                    if ($childCategory->childCategories->count()) {
                        $catEntry['childs'] = self::getChildCategoryTree($childCategory->id, $result);
                    }
                    $result[] = $catEntry;
                }

                return $result;
            }
        }
    }

    public function level()
    {
        $parents = $this->getParentCategoryTree();

        return count($parents) + 1;
    }


    public function url()
    {
        $params = ["id" => $this->id];

        return route('admin.category.edit', $params);
    }

    public function subUrl()
    {
        $params = ['slug' => $this->parentCategory->slug, 'subCategory' => $this->id];

        return route('front.category.detail', $params);
    }

    public function photo()
    {
        return $this->hasOne(Media::class, 'id', 'photo_id');
    }

    public function getPhoto($variation = null)
    {
        return $this->photo_id ? str_replace("\\", "/", $this->photo->url()) : _asset('images/no-image.svg');
    }

    public function cover()
    {
        return $this->hasOne(Media::class, 'id', 'cover_id');
    }

    public function getCover()
    {
        return $this->cover_id ? str_replace("\\", "/", $this->cover->url()) : _asset('images/no-image.svg');
    }

    public function banner()
    {
        return $this->hasOne(Media::class, 'id', 'banner_id');
    }

    public function getBanner()
    {
        return $this->banner_id ? str_replace("\\", "/", $this->banner->url()) : _asset('images/no-image.svg');
    }

    public function mini1()
    {
        return $this->hasOne(Media::class, 'id', 'mini_png1');
    }

    public function getMini1()
    {
        return $this->mini_png1 ? str_replace("\\", "/", $this->mini1->url()) : _asset('images/no-image.svg');
    }

    public function mini2()
    {
        return $this->hasOne(Media::class, 'id', 'mini_png2');
    }

    public function getMini2()
    {
        return $this->mini_png2 ? str_replace("\\", "/", $this->mini2->url()) : _asset('images/no-image.svg');
    }

}
