<?php

namespace App\Packages\Category;

use App\Packages\Category\Models\Category;
use App\Packages\Category\Models\Product;
use App\Packages\Category\Requests\CategoryRequest;
use App\Packages\Category\Requests\InquiryRequest;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Nette\Admin\Controllers\AdminBaseController as BaseController;
use FilterGenerator;

class CategoryController extends BaseController
{
    public $cTitle = 'Kategoriler';

    public $cMenuKey = 'category';
    public $cModel = Category::class;
    public $cModelName = 'Kategori';

    public $cKey = 'category';

    public $cIndexBlade = "Category::index";
    public $cIndexRoute = 'admin.category.index';
    public $cIndexTitle = 'Liste';
    public $cIndexPermission = 'category.view';

    //region Create Settings
    public $cCreate = true;
    public $cCreateRoute = 'admin.category.create';
    public $cCreateTitle = 'Yeni';
    public $cCreateMethodRoute = 'admin.category.store';
    public $cCreatePermission = 'category.create';
    public $cCreateBlade = 'Category::create';
    //endregion


    //region Edit Settings
    public $cEdit = true;
    public $cEditRoute = 'admin.category.edit';
    public $cEditTitle = 'Düzenle';
    public $cEditMethodRoute = 'admin.category.update';
    public $cEditPermission = 'category.edit';
    //endregion

    public $cOrderMediaRoute = 'admin.category.ordermedia';
    public $cUpdateMediaRoute = 'admin.category.updatemedia';
    public $cDeleteMediaRoute = 'admin.category.deletemedia';


    public $cOrderable = true;
    public $cOrderableColumn = 'order_number';
    public $cOrderableRoute = 'admin.category.orderable';


    //region Publish Settings
    public $cPublish = true;
    public $cPublishRoute = 'admin.category.publish';
    public $cPublishTitle = 'Yayınla';
    public $cPublishPermission = 'category.publish';
    //endregion


    //region Delete Settings
    public $cDelete = true;
    public $cDeleteRoute = 'admin.category.destroy';
    public $cDeleteTitle = 'Sil';
    public $cDeletePermission = 'category.delete';
    //endregion

    public $cFields = [
        'id' => ['name' => 'ID', 'sortable' => true, 'size' => 'mini'],
        'name_tr' => ['name' => 'Kategori Adı'],
        'parent_id' => ['name' => 'İlişkili Kategori', 'size' => 'medium'],
    ];

    public $cFieldMutators = [
//        'category_id' => 'videoCategoryName',
        'created_at' => 'globalDate',
        'parent_id' => ['method' => 'parentName', 'parameter' => 'object'],
        'name' => ['method' => 'frontUrl', 'parameter' => 'object']
    ];

    public $cSidebarModules = [
        'Category::_partials.status',
        'Category::_partials.category',
    ];


    public $cModuleFiles = [
        [
            'name' => 'Kategori Cover',
            'type' => 'img',
            'key' => 'category_cover',
            'database_key' => 'cover_id',
            'multiple' => false,
            'attach_func' => 'cover'
        ],

        [
            'name' => 'Kategori Banner',
            'type' => 'img',
            'key' => 'category_banner',
            'database_key' => 'banner_id',
            'multiple' => false,
            'attach_func' => 'banner'
        ],

        [
            'name' => 'Kategori 1. Mini Gorsel',
            'type' => 'img',
            'key' => 'category_mini1',
            'database_key' => 'mini_png1',
            'multiple' => false,
            'attach_func' => 'mini1'
        ],

        [
            'name' => 'Kategori 2. Mini Gorsel',
            'type' => 'img',
            'key' => 'category_mini2',
            'database_key' => 'mini_png2',
            'multiple' => false,
            'attach_func' => 'mini2'
        ],

/*
        [
            'name' => 'Kategori Kapak Resmi',
            'type' => 'img',
            'key' => 'category',
            'database_key' => 'photo_id',
            'multiple' => false,
            'attach_func' => 'photo'
        ], [
            'name' => 'Kategori Banner Resmi',
            'type' => 'img',
            'key' => 'category_banner',
            'database_key' => 'banner_id',
            'multiple' => false,
            'attach_func' => 'banner'
        ],*/

    ];

    public $cFilterable = true;

    public $filters = [
        'name_tr' => [
            'name' => 'Kategori Adı',
            'type' => 'text',
            'operator' => 'like'
        ]
    ];


    public function __construct()
    {
        view()->share('categories', Category::published()->get()->pluck('name_tr', 'id')->toArray());
        parent::__construct();
    }

    public function store(CategoryRequest $request)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        $data = parent::_store($request, true);

        if ($data) {
            $request->session()->flash('success', 'Kayıt İşlemi Başarılı!');
        }

        return redirect()->route($this->cIndexRoute);
    }

    public function update(CategoryRequest $request, $id)
    {
        $request['created_at'] = $request->created_at ?? Carbon::now();
        return parent::_update($request, $id);
    }

}
