<?php

namespace App\Packages\ArticleCat\Models;


use App\Packages\Article\Models\Article;
use App\Packages\Catalog\Models\Catalog;
use App\Packages\Product\Models\Product;
use Nette\Admin\Models\BaseModel;
use Cviebrock\EloquentSluggable\Sluggable;
use Nette\Multilingual\Traits\MultiLingualModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Nette\Admin\Traits\SlugTrait;
use Nette\Upload\Models\Media;

class ArticleCat extends BaseModel
{
    use SoftDeletes;
    use Sluggable;
    use SlugTrait;

    use MultiLingualModel;

    protected $table = 'article_cats';

    protected $multiLingualFillable = [
        'name',
        'slug',
        'content',
        'short_content',
        'long_content',
    ];

    protected $fillable = [
        'cover_id',
        'banner_id',
        'mini_png1',
        'mini_png2',
        'banner_id',
        'home_showroom',
        'photo_id',
        'author',
        'edit_author',
        'parent_id',
        'status',
        'home_page_view',
        'banner_id',
        'date',
        'meta',
        'style',
        'lock',
        'key',
        'subkey',
    ];

    protected $hidden = [

    ];

    protected $casts = [
        'meta' => 'array',
    ];

    protected $with = [];

    protected $appends = ['url', 'date_published', 'date_modified', 'created_at_str'];

    public static $slug = [
        //'name' => 'slug'
    ];

    public static $multiLingualSlug = [
        'name' => 'slug',
    ];

    public static $checks = [
        'status', 'home_page_view', 'home_showroom',
    ];

    public static $zeros = [

    ];

    public static $rules = [
    ];

    public static $multiLingualRules = [
        'name' => 'required',
    ];

    public static $attr = [
        'name' => 'Kategori adı',
    ];

    public function sluggable()
    {
        return $this->autoSluggable();
    }

    public function tags()
    {
        return $this->morphToMany(Tag::class, 'taggable', 'taggings');
    }

    public function articles()
    {
        return $this->hasMany(Article::class, 'article_cat_id', 'id')->published();
    }


    // Alt kategori sistemi

    public function childArticleCats()
    {
        return $this->hasMany(ArticleCat::class, 'parent_id', 'id');
    }

    public function parentArticleCat()
    {
        return $this->hasOne(ArticleCat::class, 'id', 'parent_id');
    }


    public function getParentArticleCatTree($id = null, $result = [])
    {
        if (is_null($id)) {
            $id = $this->id;
        }
        $obj = self::find($id);
        if ($obj) {
            if ($obj->parent_id != null) {
                $result[] = $obj->parentArticleCat;

                return $this->getParentArticleCatTree($obj->parent_id, $result);
            }
        }

        return $result;
    }

    public function getChildArticleCatTree($id = null, $result = [])
    {
        if (is_null($id)) {
            $id = $this->id;
        }
        $obj = self::find($id);
        if ($obj) {
            if ($obj->childArticleCats->count()) {
                foreach ($obj->childArticleCats as $childArticleCat) {
                    $catEntry = ['cat' => $childArticleCat];
                    if ($childArticleCat->childArticleCats->count()) {
                        $catEntry['childs'] = self::getChildArticleCatTree($childArticleCat->id, $result);
                    }
                    $result[] = $catEntry;
                }

                return $result;
            }
        }
    }

    public function level()
    {
        $parents = $this->getParentArticleCatTree();

        return count($parents) + 1;
    }


    public function url()
    {
        $params = ["id" => $this->id];

        return route('admin.article_cat.edit', $params);
    }

    public function subUrl()
    {
        $params = ['slug' => $this->parentArticleCat->slug, 'subArticleCat' => $this->id];

        return route('front.article_cat.detail', $params);
    }

}
